/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.common.dto;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.Attribute;

public abstract class BaseResource
implements Serializable {
    protected static final Log LOG = Log.getLog(BaseResource.class);
    private static final long serialVersionUID = -7603956873008734403L;
    protected Set<String> schemas = new TreeSet<String>();

    public BaseResource(String baseSchema) {
        this.schemas.add(baseSchema);
    }

    public Set<String> getSchemas() {
        return this.schemas;
    }

    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public void setSchemas(Set<String> schemas) {
        this.schemas.clear();
        this.schemas.addAll(schemas);
    }

    public abstract Set<Attribute> toAttributes() throws IllegalArgumentException, IllegalAccessException;

    public abstract void fromAttributes(Set<Attribute> var1);
}

