/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class HttpClientConnection {
    public static final int HTTP_DEFAULTPORT = 80;
    private String hostname;
    private int port = 80;
    private Socket socket;
    private int timeout = 30000;
    private boolean keepAlive = true;
    private boolean chunkedTransfer;
    private int remainingChunkLength;
    private boolean finalChunkSeen;
    private String contentType;
    private OutputStream out;
    private InputStream in;
    private int responseCode;
    private byte[] asciiBuffer = new byte[1024];
    private char[] headerLine = new char[80];
    private String userAgentId = "Not Mozilla, but RemoteTea v1.1.2";
    private static final int HTTP_DEAD = 0;
    private static final int HTTP_IDLE = 1;
    private static final int HTTP_SENDING = 2;
    private static final int HTTP_RECEIVING = 3;
    private int mode = 1;
    private int remainingContentLength;
    public static final byte[] CRLF = new byte[]{13, 10};
    private boolean useProxy = false;
    private String cachedProxyHost;
    private int cachedProxyPort;

    public HttpClientConnection(String hostname) {
        this(hostname, 80);
    }

    public HttpClientConnection(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
        this.mode = 0;
    }

    public void close() {
        if (this.socket != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
            this.out = null;
            this.in = null;
        }
        this.mode = 0;
    }

    public void beginPostRequest(String path, String mimeType, int contentLength) throws IOException {
        this.connect();
        this.remainingContentLength = contentLength;
        this.mode = 2;
        this.socket.setSoTimeout(this.timeout);
        if (this.useProxy) {
            this.writeln("POST http://" + this.hostname + path + " HTTP/1.1");
        } else {
            this.writeln("POST " + path + " HTTP/1.1");
        }
        if (!this.useProxy) {
            this.writeln("Host: " + this.hostname);
        }
        this.writeln("User-Agent: " + this.userAgentId);
        if (this.useProxy) {
            this.writeln("Proxy-Connection: keep-alive");
        } else {
            this.writeln("Connection: keep-alive");
        }
        this.writeln("Cache-Control: no-cache, no-store, private");
        this.writeln("Pragma: no-cache");
        this.writeln("Content-Type: " + mimeType);
        if (contentLength <= 0) {
            throw new ProtocolException("ONC/RPC HTTP-tunnel POST needs content length to keep the connection alive");
        }
        this.writeln("Content-Length: " + contentLength);
        this.writeln("");
    }

    public void writeContentBytes(byte[] bytes, int offset, int length) throws IOException {
        if (this.mode != 2) {
            throw new ProtocolException("ONC/RPC HTTP tunnel not in sending mode");
        }
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > bytes.length || length < 0 || offset + length > bytes.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        if (this.remainingContentLength >= 0) {
            this.remainingContentLength -= length;
            if (this.remainingContentLength < 0) {
                this.close();
                throw new ProtocolException("ONC/RPC HTTP tunnel received too much content");
            }
        }
        try {
            this.out.write(bytes, offset, length);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public void endPostRequest() throws IOException {
        if (this.remainingContentLength > 0) {
            this.close();
            throw new ProtocolException("ONC/RPC HTTP tunnel received not enough content");
        }
        try {
            this.out.flush();
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        this.mode = 1;
    }

    protected void handleOption(String option, String value) {
        if ("Content-Length".equalsIgnoreCase(option)) {
            try {
                this.remainingContentLength = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("Content-Type".equalsIgnoreCase(option)) {
            this.contentType = value;
        } else if ("Proxy-Connection".equalsIgnoreCase(option)) {
            if (this.useProxy) {
                this.keepAlive = "Keep-Alive".equalsIgnoreCase(value);
            }
        } else if ("Connection".equalsIgnoreCase(option)) {
            if (!this.useProxy) {
                this.keepAlive = "Keep-Alive".equalsIgnoreCase(value);
            }
        } else if ("Transfer-Encoding".equalsIgnoreCase(option)) {
            this.chunkedTransfer = "chunked".equalsIgnoreCase(value);
        }
    }

    private int readHeaders() throws IOException {
        int httpStatus;
        String[] param;
        this.keepAlive = false;
        this.remainingContentLength = 0;
        this.chunkedTransfer = false;
        this.remainingChunkLength = 0;
        this.contentType = null;
        do {
            int index;
            if (!this.readHeaderLine(param = new String[1]) || !param[0].startsWith("HTTP/")) {
                throw new IOException("Invalid HTTP header");
            }
            String header = param[0];
            int len = header.length();
            for (index = 0; index < len && header.charAt(index) != ' '; ++index) {
            }
            while (index < len && header.charAt(index) == ' ') {
                ++index;
            }
            try {
                this.responseCode = 300;
                this.responseCode = httpStatus = Integer.parseInt(header.substring(index, index + 3));
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid HTTP header");
            }
        } while (this.responseCode == 100);
        param = new String[2];
        while (this.readHeaderLine(param)) {
            this.handleOption(param[0], param[1]);
        }
        if (this.remainingContentLength <= 0) {
            this.keepAlive = false;
            this.remainingContentLength = -1;
        }
        return httpStatus;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean readHeaderLine(String[] keyvalue) throws IOException {
        int ch;
        int headerSize = this.headerLine.length;
        int index = 0;
        boolean option = keyvalue.length > 1;
        int colon = -1;
        block5: while ((ch = this.in.read()) >= 0) {
            switch (ch) {
                case 58: {
                    if (colon >= 0) break;
                    colon = index;
                    break;
                }
                case 9: {
                    ch = 32;
                    break;
                }
                case 10: 
                case 13: {
                    this.in.mark(1);
                    int nextch = this.in.read();
                    if (ch == 13 && nextch == 10) {
                        this.in.mark(1);
                        nextch = this.in.read();
                        if (nextch != 32 && nextch != 9) {
                            this.in.reset();
                            break block5;
                        }
                    } else {
                        this.in.reset();
                    }
                    ch = 32;
                }
            }
            if (index >= headerSize) {
                char[] newHeaderLine = new char[headerSize * 2];
                System.arraycopy(this.headerLine, 0, newHeaderLine, 0, headerSize);
                this.headerLine = newHeaderLine;
                headerSize *= 2;
            }
            this.headerLine[index++] = (char)ch;
        }
        if (index == 0) {
            return false;
        }
        while (--index > 0 && this.headerLine[index] <= ' ') {
        }
        ++index;
        if (!option) {
            keyvalue[0] = new String(this.headerLine, 0, index);
            return true;
        }
        if (colon <= 0) {
            keyvalue[0] = new String(this.headerLine, 0, index);
            keyvalue[1] = null;
            return true;
        }
        keyvalue[0] = new String(this.headerLine, 0, colon);
        while (++colon < index && this.headerLine[colon] <= ' ') {
        }
        keyvalue[1] = new String(this.headerLine, colon, index - colon);
        return true;
    }

    private String readLine() throws IOException {
        int ch;
        int headerSize = this.headerLine.length;
        int index = 0;
        block3: while ((ch = this.in.read()) >= 0) {
            switch (ch) {
                case 10: 
                case 13: {
                    this.in.mark(1);
                    int nextch = this.in.read();
                    if (ch == 13 && nextch == 10) break block3;
                    this.in.reset();
                    ch = 32;
                }
                default: {
                    if (index >= headerSize) {
                        char[] newHeaderLine = new char[headerSize * 2];
                        System.arraycopy(this.headerLine, 0, newHeaderLine, 0, headerSize);
                        this.headerLine = newHeaderLine;
                        headerSize *= 2;
                    }
                    this.headerLine[index++] = (char)ch;
                    continue block3;
                }
            }
        }
        return new String(this.headerLine, 0, index);
    }

    public int beginDecoding() throws IOException {
        this.mode = 3;
        this.finalChunkSeen = false;
        this.readHeaders();
        switch (this.responseCode) {
            case 200: {
                break;
            }
            default: {
                this.endDecoding();
            }
        }
        return this.responseCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int readContentBytes(byte[] buffer, int offset, int length) throws IOException {
        int total = 0;
        if (this.mode != 3) {
            throw new ProtocolException("ONC/RPC HTTP tunnel not in receiving mode");
        }
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > buffer.length || length < 0 || offset + length > buffer.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        if (this.remainingContentLength >= 0 && this.remainingContentLength < length) {
            this.close();
            throw new ProtocolException("ONC/RPC HTTP tunnel has not enough content available");
        }
        if (this.chunkedTransfer) {
            try {
                while (true) {
                    if (this.remainingChunkLength <= 0) {
                        if (this.finalChunkSeen) {
                            throw new ProtocolException("ONC/RPC HTTP tunnel has not enough content available");
                        }
                        String hexLen = this.readLine();
                        try {
                            this.remainingChunkLength = Integer.parseInt(hexLen.trim(), 16);
                            if (this.remainingChunkLength < 0) {
                                throw new NumberFormatException("must not be negative");
                            }
                        }
                        catch (NumberFormatException e) {
                            throw new ProtocolException("HTTP chunking transfer protocol violation: invalid chunk length \"" + hexLen + "\"");
                        }
                        if (this.remainingChunkLength == 0) {
                            this.finalChunkSeen = true;
                            return total;
                        }
                    }
                    while (this.remainingChunkLength > 0) {
                        int toRead = length <= this.remainingChunkLength ? length : this.remainingChunkLength;
                        int bytesread = this.in.read(buffer, offset, toRead);
                        if (bytesread < 0) {
                            throw new ProtocolException("ONC/RPC HTTP tunnel has not enough content available");
                        }
                        offset += bytesread;
                        total += bytesread;
                        this.remainingChunkLength -= bytesread;
                        if ((length -= bytesread) > 0) continue;
                        if (this.remainingChunkLength <= 0) {
                            this.readLine();
                        }
                        return total;
                    }
                    this.readLine();
                }
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }
        try {
            while (length > 0) {
                int bytesread = this.in.read(buffer, offset, length);
                if (bytesread < 0) {
                    if (this.remainingContentLength >= 0) {
                        throw new ProtocolException("ONC/RPC HTTP tunnel has not enough content available");
                    }
                    break;
                }
                total += bytesread;
                offset += bytesread;
                length -= bytesread;
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        finally {
            if (this.remainingContentLength >= 0) {
                this.remainingContentLength -= total;
            }
        }
        return total;
    }

    public int getRemainingContentLength() {
        return this.remainingContentLength;
    }

    public void endDecoding() throws IOException {
        if (this.chunkedTransfer) {
            if (this.keepAlive && !this.finalChunkSeen) {
                try {
                    long bytesSkipped;
                    while (this.remainingChunkLength > 0) {
                        bytesSkipped = this.in.skip(this.remainingChunkLength);
                        if (bytesSkipped < 0L) {
                            throw new IOException("Could not skip chunk");
                        }
                        this.remainingChunkLength = (int)((long)this.remainingChunkLength - bytesSkipped);
                    }
                    while (!this.finalChunkSeen) {
                        String hexLen = this.readLine();
                        int chunkLength = Integer.parseInt(hexLen, 16);
                        if (chunkLength < 0) {
                            throw new NumberFormatException("must not be negative");
                        }
                        if (chunkLength == 0) break;
                        while (chunkLength > 0) {
                            bytesSkipped = this.in.skip(this.remainingChunkLength);
                            if (bytesSkipped < 0L) {
                                throw new IOException("Could not skip chunk");
                            }
                            chunkLength = (int)((long)chunkLength - bytesSkipped);
                        }
                        this.readLine();
                    }
                }
                catch (Exception e) {
                    this.close();
                }
            }
        } else if (this.keepAlive) {
            if (this.remainingContentLength > 0) {
                while (this.remainingContentLength > 0) {
                    long bytesSkipped = this.in.skip(this.remainingContentLength);
                    if (bytesSkipped < 0L) {
                        this.close();
                        break;
                    }
                    this.remainingContentLength = (int)((long)this.remainingContentLength - bytesSkipped);
                }
            } else if (this.remainingContentLength < 0) {
                this.close();
            }
        }
        if (this.mode != 0) {
            if (!this.keepAlive) {
                this.close();
            } else {
                this.mode = 1;
            }
        }
    }

    public void setTimeout(int milliseconds) {
        if (milliseconds <= 0) {
            throw new IllegalArgumentException("timeouts must be positive.");
        }
        this.timeout = milliseconds;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    private void connect() throws IOException {
        SecurityManager security;
        if (this.socket != null) {
            if (this.keepAlive) {
                return;
            }
            this.close();
        }
        if ((security = System.getSecurityManager()) != null) {
            security.checkConnect(this.hostname, this.port);
        }
        if (this.cachedProxyHost != null) {
            this.socket = new Socket(this.cachedProxyHost, this.cachedProxyPort);
            this.useProxy = true;
        } else {
            final String proxyHost = this.getProxyHost();
            if (proxyHost != null) {
                final int proxyPort = this.getProxyPort();
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            HttpClientConnection.this.socket = new Socket(proxyHost, proxyPort);
                            HttpClientConnection.this.useProxy = true;
                            HttpClientConnection.this.cachedProxyHost = proxyHost;
                            HttpClientConnection.this.cachedProxyPort = proxyPort;
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    this.useProxy = false;
                    this.socket = new Socket(InetAddress.getByName(this.hostname), this.port);
                }
            } else {
                this.useProxy = false;
                this.socket = new Socket(InetAddress.getByName(this.hostname), this.port);
            }
        }
        this.socket.setTcpNoDelay(true);
        this.out = new BufferedOutputStream(this.socket.getOutputStream(), 4096);
        this.in = new BufferedInputStream(this.socket.getInputStream(), 4096);
        this.keepAlive = true;
    }

    private void write(String s) throws IOException {
        int len;
        int sindex = 0;
        int blocklen = this.asciiBuffer.length;
        for (int slen = s.length(); slen > 0; slen -= len) {
            len = slen > blocklen ? blocklen : slen;
            for (int index = 0; index < len; ++index) {
                this.asciiBuffer[index] = (byte)s.charAt(sindex++);
            }
            this.out.write(this.asciiBuffer, 0, len);
        }
    }

    private void writeln(String s) throws IOException {
        this.write(s);
        this.out.write(CRLF);
    }

    private String getProxyHost() {
        String proxyHost = (String)AccessController.doPrivileged(new GetPropertyPrivilegedAction("http.proxyHost"));
        if (proxyHost == null) {
            proxyHost = (String)AccessController.doPrivileged(new GetPropertyPrivilegedAction("proxyHost"));
        }
        return proxyHost;
    }

    private int getProxyPort() {
        String proxyPort = (String)AccessController.doPrivileged(new GetPropertyPrivilegedAction("http.proxyPort"));
        if (proxyPort == null) {
            proxyPort = (String)AccessController.doPrivileged(new GetPropertyPrivilegedAction("proxyPort"));
        }
        if (proxyPort != null) {
            try {
                return Integer.parseInt(proxyPort);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 80;
    }

    class GetPropertyPrivilegedAction
    implements PrivilegedAction {
        private String property;
        private String defaultValue;

        public GetPropertyPrivilegedAction(String property) {
            this.property = property;
        }

        public GetPropertyPrivilegedAction(String property, String defaultValue) {
            this.property = property;
            this.defaultValue = defaultValue;
        }

        public Object run() {
            return System.getProperty(this.property, this.defaultValue);
        }
    }
}

