/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.test;

import java.time.Instant;
import java.util.Date;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.impl.test.JobTestHelper;
import org.flowable.engine.test.mock.FlowableMockSupport;

public class FlowableTestHelper {
    protected final ProcessEngine processEngine;
    protected final FlowableMockSupport mockSupport;
    protected String deploymentIdFromDeploymentAnnotation;

    public FlowableTestHelper(ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.mockSupport = FlowableMockSupport.isMockSupportPossible(this.processEngine) ? new FlowableMockSupport(this.processEngine) : null;
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public String getDeploymentIdFromDeploymentAnnotation() {
        return this.deploymentIdFromDeploymentAnnotation;
    }

    public void setDeploymentIdFromDeploymentAnnotation(String deploymentIdFromDeploymentAnnotation) {
        this.deploymentIdFromDeploymentAnnotation = deploymentIdFromDeploymentAnnotation;
    }

    public FlowableMockSupport getMockSupport() {
        return this.mockSupport;
    }

    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait, long intervalMillis) {
        JobTestHelper.waitForJobExecutorToProcessAllJobs(this.processEngine.getProcessEngineConfiguration(), this.processEngine.getManagementService(), maxMillisToWait, intervalMillis);
    }

    public void setCurrentTime(Date date) {
        this.processEngine.getProcessEngineConfiguration().getClock().setCurrentTime(date);
    }

    public void setCurrentTime(Instant instant) {
        this.processEngine.getProcessEngineConfiguration().getClock().setCurrentTime(instant == null ? null : Date.from(instant));
    }
}

