/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history;

import java.util.Date;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.HistoryManager;
import org.flowable.variable.service.history.InternalHistoryVariableManager;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class DefaultHistoryVariableManager
implements InternalHistoryVariableManager {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public DefaultHistoryVariableManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public void recordVariableCreate(VariableInstanceEntity variable, Date createTime) {
        this.getHistoryManager().recordVariableCreate(variable, createTime);
        if (variable.getProcessInstanceId() != null || variable.getExecutionId() != null || variable.getTaskId() != null) {
            this.getHistoryManager().recordHistoricDetailVariableCreate(variable, null, false, null, createTime);
        }
    }

    public void recordVariableUpdate(VariableInstanceEntity variable, Date updateTime) {
        this.getHistoryManager().recordVariableUpdate(variable, updateTime);
        if (variable.getProcessInstanceId() != null || variable.getExecutionId() != null || variable.getTaskId() != null) {
            this.getHistoryManager().recordHistoricDetailVariableCreate(variable, null, false, null, updateTime);
        }
    }

    public void recordVariableRemoved(VariableInstanceEntity variable, Date removeTime) {
        this.getHistoryManager().recordVariableRemoved(variable);
        if (variable.getProcessInstanceId() != null || variable.getExecutionId() != null || variable.getTaskId() != null) {
            this.getHistoryManager().recordHistoricDetailVariableCreate(variable, null, false, null, removeTime);
        }
    }

    protected HistoryManager getHistoryManager() {
        return this.processEngineConfiguration.getHistoryManager();
    }
}

