/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20RevocationRequestValidator
implements OAuth20TokenRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20RevocationRequestValidator.class);
    private final ServicesManager servicesManager;
    private final SessionStore sessionStore;
    private final OAuth20RequestParameterResolver requestParameterResolver;
    private int order = Integer.MAX_VALUE;

    public boolean validate(WebContext context) {
        CallContext callContext = new CallContext(context, this.sessionStore);
        String clientId = (String)this.requestParameterResolver.resolveClientIdAndClientSecret(callContext).getLeft();
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, clientId);
        if (registeredService == null) {
            LOGGER.warn("Provided client id [{}] cannot be matched against a service definition", (Object)clientId);
            return false;
        }
        return true;
    }

    public boolean supports(WebContext context) {
        String token = this.requestParameterResolver.resolveRequestParameter(context, "token").map(String::valueOf).orElse("");
        if (StringUtils.isBlank((CharSequence)token)) {
            return false;
        }
        CallContext callContext = new CallContext(context, this.sessionStore);
        String clientId = (String)this.requestParameterResolver.resolveClientIdAndClientSecret(callContext).getLeft();
        return StringUtils.isNotBlank((CharSequence)clientId);
    }

    @Generated
    public OAuth20RevocationRequestValidator(ServicesManager servicesManager, SessionStore sessionStore, OAuth20RequestParameterResolver requestParameterResolver) {
        this.servicesManager = servicesManager;
        this.sessionStore = sessionStore;
        this.requestParameterResolver = requestParameterResolver;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public SessionStore getSessionStore() {
        return this.sessionStore;
    }

    @Generated
    public OAuth20RequestParameterResolver getRequestParameterResolver() {
        return this.requestParameterResolver;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

