/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.collection;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.springframework.util.Assert;

public abstract class AbstractCachingMapDecorator<K, V>
implements Map<K, V>,
Serializable {
    private static Object NULL_VALUE = new Object();
    private final Map<K, Object> targetMap;
    private final boolean synchronize;
    private final boolean weak;

    public AbstractCachingMapDecorator() {
        this(false);
    }

    public AbstractCachingMapDecorator(boolean weak) {
        AbstractMap internalMap = weak ? new WeakHashMap() : new HashMap();
        this.targetMap = Collections.synchronizedMap(internalMap);
        this.synchronize = true;
        this.weak = weak;
    }

    public AbstractCachingMapDecorator(boolean weak, int size) {
        AbstractMap internalMap = weak ? new WeakHashMap(size) : new HashMap(size);
        this.targetMap = Collections.synchronizedMap(internalMap);
        this.synchronize = true;
        this.weak = weak;
    }

    public AbstractCachingMapDecorator(Map<K, V> targetMap) {
        this(targetMap, false, false);
    }

    public AbstractCachingMapDecorator(Map<K, V> targetMap, boolean synchronize, boolean weak) {
        Assert.notNull(targetMap, (String)"'targetMap' must not be null");
        this.targetMap = synchronize ? Collections.synchronizedMap(targetMap) : targetMap;
        this.synchronize = synchronize;
        this.weak = weak;
    }

    @Override
    public int size() {
        return this.targetMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.targetMap.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        Object valueToCheck;
        Object object = valueToCheck = value != null ? value : NULL_VALUE;
        if (this.synchronize) {
            Map<K, Object> map = this.targetMap;
            synchronized (map) {
                return this.containsValueOrReference(valueToCheck);
            }
        }
        return this.containsValueOrReference(valueToCheck);
    }

    private boolean containsValueOrReference(Object value) {
        if (this.targetMap.containsValue(value)) {
            return true;
        }
        for (Object mapVal : this.targetMap.values()) {
            if (!(mapVal instanceof Reference) || !value.equals(((Reference)mapVal).get())) continue;
            return true;
        }
        return false;
    }

    @Override
    public V remove(Object key) {
        return this.unwrapReturnValue(this.targetMap.remove(key));
    }

    private V unwrapReturnValue(Object value) {
        Object returnValue = value;
        if (returnValue instanceof Reference) {
            returnValue = ((Reference)returnValue).get();
        }
        return (V)(returnValue == NULL_VALUE ? null : returnValue);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.targetMap.putAll(map);
    }

    @Override
    public void clear() {
        this.targetMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        if (this.synchronize) {
            Map<K, Object> map = this.targetMap;
            synchronized (map) {
                return new LinkedHashSet<K>(this.targetMap.keySet());
            }
        }
        return new LinkedHashSet<K>(this.targetMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        if (this.synchronize) {
            Map<K, Object> map = this.targetMap;
            synchronized (map) {
                return this.valuesCopy();
            }
        }
        return this.valuesCopy();
    }

    private Collection<V> valuesCopy() {
        LinkedList<Object> values = new LinkedList<Object>();
        Iterator<Object> it = this.targetMap.values().iterator();
        while (it.hasNext()) {
            Object value = it.next();
            if (value instanceof Reference && (value = ((Reference)value).get()) == null) {
                it.remove();
                continue;
            }
            values.add(value == NULL_VALUE ? null : value);
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.synchronize) {
            Map<K, Object> map = this.targetMap;
            synchronized (map) {
                return this.entryCopy();
            }
        }
        return this.entryCopy();
    }

    private Set<Map.Entry<K, V>> entryCopy() {
        LinkedHashMap<K, Object> entries = new LinkedHashMap<K, Object>();
        Iterator<Map.Entry<K, Object>> it = this.targetMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, Object> entry = it.next();
            Object value = entry.getValue();
            if (value instanceof Reference && (value = ((Reference)value).get()) == null) {
                it.remove();
                continue;
            }
            entries.put(entry.getKey(), value == NULL_VALUE ? null : value);
        }
        return entries.entrySet();
    }

    @Override
    public V put(K key, V value) {
        Object newValue = value;
        if (value == null) {
            newValue = NULL_VALUE;
        } else if (this.useWeakValue(key, value)) {
            newValue = new WeakReference<V>(newValue);
        }
        return this.unwrapReturnValue(this.targetMap.put(key, newValue));
    }

    protected boolean useWeakValue(K key, V value) {
        return this.weak;
    }

    @Override
    public V get(Object key) {
        Object value = this.targetMap.get(key);
        if (value instanceof Reference) {
            value = ((Reference)value).get();
        }
        if (value == null) {
            V newValue = this.create(key);
            this.put(key, newValue);
            return newValue;
        }
        return (V)(value == NULL_VALUE ? null : value);
    }

    protected abstract V create(K var1);

    public String toString() {
        return "CachingMapDecorator [" + this.getClass().getName() + "]:" + this.targetMap;
    }
}

