/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.store;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import org.opensaml.core.xml.XMLObject;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.saml.store.SAMLMessageStore;
import org.pac4j.saml.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionStore
implements SAMLMessageStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpSessionStore.class);
    private final WebContext context;
    private final SessionStore sessionStore;
    private LinkedHashMap<String, String> internalMessages;
    private static final String SAML_STORAGE_KEY = "_springSamlStorageKey";

    public void set(String messageID, XMLObject message) {
        LOGGER.debug("Storing message {} to session {}", (Object)messageID, this.sessionStore.getSessionId(this.context, true).orElseThrow());
        LinkedHashMap<String, String> messages = this.getMessages();
        messages.put(messageID, Configuration.serializeSamlObject(message).toString());
        this.updateSession(messages);
    }

    public Optional<XMLObject> get(String messageID) {
        LinkedHashMap<String, String> messages = this.getMessages();
        String o = messages.get(messageID);
        if (o == null) {
            LOGGER.debug("Message {} not found in session {}", (Object)messageID, this.sessionStore.getSessionId(this.context, true).orElseThrow());
            return Optional.empty();
        }
        LOGGER.debug("Message {} found in session {}, clearing", (Object)messageID, this.sessionStore.getSessionId(this.context, true).orElseThrow());
        messages.clear();
        this.updateSession(messages);
        return Configuration.deserializeSamlObject(o);
    }

    private LinkedHashMap<String, String> getMessages() {
        if (this.internalMessages == null) {
            this.internalMessages = this.initializeSession();
        }
        return this.internalMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedHashMap<String, String> initializeSession() {
        Optional messages = this.sessionStore.get(this.context, SAML_STORAGE_KEY);
        if (messages.isEmpty()) {
            WebContext webContext = this.context;
            synchronized (webContext) {
                messages = this.sessionStore.get(this.context, SAML_STORAGE_KEY);
                if (messages.isEmpty()) {
                    messages = Optional.of(new LinkedHashMap());
                    this.updateSession(messages.get());
                }
            }
        }
        return (LinkedHashMap)messages.get();
    }

    private void updateSession(LinkedHashMap<String, String> messages) {
        this.sessionStore.set(this.context, SAML_STORAGE_KEY, messages);
    }

    public void remove(String key) {
        this.set(key, null);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HttpSessionStore(WebContext context, SessionStore sessionStore) {
        this.context = context;
        this.sessionStore = sessionStore;
    }
}

