/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.metrics.reporters;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.storm.daemon.metrics.MetricsUtils;
import org.apache.storm.daemon.metrics.reporters.PreparableReporter;
import org.apache.storm.utils.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvPreparableReporter
implements PreparableReporter {
    private static final Logger LOG = LoggerFactory.getLogger(CsvPreparableReporter.class);
    CsvReporter reporter = null;
    Integer reportingIntervalSecs = null;

    @Override
    public void prepare(MetricRegistry metricsRegistry, Map<String, Object> daemonConf) {
        TimeUnit durationUnit;
        TimeUnit rateUnit;
        LOG.debug("Preparing...");
        CsvReporter.Builder builder = CsvReporter.forRegistry((MetricRegistry)metricsRegistry);
        Locale locale = MetricsUtils.getMetricsReporterLocale(daemonConf);
        if (locale != null) {
            builder.formatFor(locale);
        }
        if ((rateUnit = MetricsUtils.getMetricsRateUnit(daemonConf)) != null) {
            builder.convertRatesTo(rateUnit);
        }
        if ((durationUnit = MetricsUtils.getMetricsDurationUnit(daemonConf)) != null) {
            builder.convertDurationsTo(durationUnit);
        }
        File csvMetricsDir = MetricsUtils.getCsvLogDir(daemonConf);
        this.reporter = builder.build(csvMetricsDir);
        this.reportingIntervalSecs = ObjectReader.getInt((Object)daemonConf.get("storm.daemon.metrics.reporter.interval.secs"), (Integer)10);
    }

    @Override
    public void start() {
        if (this.reporter == null) {
            throw new IllegalStateException("Attempt to start without preparing " + this.getClass().getSimpleName());
        }
        LOG.debug("Starting...");
        this.reporter.start((long)this.reportingIntervalSecs.intValue(), TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        if (this.reporter == null) {
            throw new IllegalStateException("Attempt to stop without preparing " + this.getClass().getSimpleName());
        }
        LOG.debug("Stopping...");
        this.reporter.report();
        this.reporter.stop();
    }
}

