/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.common;

import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.common.TcpSocketAppenderFactory;
import jakarta.validation.constraints.NotEmpty;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import javax.net.SocketFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jspecify.annotations.Nullable;

@JsonTypeName(value="tls")
public class TlsSocketAppenderFactory<E extends DeferredProcessingAware>
extends TcpSocketAppenderFactory<E> {
    private @Nullable String keyStorePath;
    private @Nullable String keyStorePassword;
    @NotEmpty
    private String keyStoreType = "JKS";
    private @Nullable String keyStoreProvider;
    private @Nullable String trustStorePath;
    private @Nullable String trustStorePassword;
    @NotEmpty
    private String trustStoreType = "JKS";
    private @Nullable String trustStoreProvider;
    private @Nullable String jceProvider;
    private @Nullable List<String> supportedProtocols;
    private @Nullable List<String> excludedProtocols;
    private @Nullable List<String> supportedCipherSuites;
    private @Nullable List<String> excludedCipherSuites;
    private boolean validateCerts;
    private boolean validatePeers;

    @JsonProperty
    public boolean isValidatePeers() {
        return this.validatePeers;
    }

    @JsonProperty
    public void setValidatePeers(boolean validatePeers) {
        this.validatePeers = validatePeers;
    }

    @JsonProperty
    public boolean isValidateCerts() {
        return this.validateCerts;
    }

    @JsonProperty
    public void setValidateCerts(boolean validateCerts) {
        this.validateCerts = validateCerts;
    }

    @JsonProperty
    public @Nullable List<String> getExcludedCipherSuites() {
        return this.excludedCipherSuites;
    }

    @JsonProperty
    public void setExcludedCipherSuites(List<String> excludedCipherSuites) {
        this.excludedCipherSuites = excludedCipherSuites;
    }

    @JsonProperty
    public @Nullable List<String> getSupportedCipherSuites() {
        return this.supportedCipherSuites;
    }

    @JsonProperty
    public void setSupportedCipherSuites(List<String> supportedCipherSuites) {
        this.supportedCipherSuites = supportedCipherSuites;
    }

    @JsonProperty
    public @Nullable List<String> getExcludedProtocols() {
        return this.excludedProtocols;
    }

    @JsonProperty
    public void setExcludedProtocols(List<String> excludedProtocols) {
        this.excludedProtocols = excludedProtocols;
    }

    @JsonProperty
    public @Nullable List<String> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    @JsonProperty
    public void setSupportedProtocols(List<String> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    @JsonProperty
    public @Nullable String getTrustStoreProvider() {
        return this.trustStoreProvider;
    }

    @JsonProperty
    public void setTrustStoreProvider(String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
    }

    @JsonProperty
    public @Nullable String getTrustStoreType() {
        return this.trustStoreType;
    }

    @JsonProperty
    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    @JsonProperty
    public @Nullable String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @JsonProperty
    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @JsonProperty
    public @Nullable String getTrustStorePath() {
        return this.trustStorePath;
    }

    @JsonProperty
    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    @JsonProperty
    public @Nullable String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    @JsonProperty
    public void setKeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    @JsonProperty
    public @Nullable String getKeyStoreType() {
        return this.keyStoreType;
    }

    @JsonProperty
    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    @JsonProperty
    public @Nullable String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @JsonProperty
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    @JsonProperty
    public @Nullable String getKeyStorePath() {
        return this.keyStorePath;
    }

    @JsonProperty
    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    @JsonProperty
    public @Nullable String getJceProvider() {
        return this.jceProvider;
    }

    @JsonProperty
    public void setJceProvider(String jceProvider) {
        this.jceProvider = jceProvider;
    }

    private SslContextFactory createSslContextFactory() {
        SslContextFactory.Server factory = new SslContextFactory.Server();
        if (this.keyStorePath != null) {
            factory.setKeyStorePath(this.keyStorePath);
        }
        factory.setKeyStoreType(this.keyStoreType);
        if (this.keyStorePassword != null) {
            factory.setKeyStorePassword(this.keyStorePassword);
        }
        if (this.keyStoreProvider != null) {
            factory.setKeyStoreProvider(this.keyStoreProvider);
        }
        if (this.trustStorePath != null) {
            factory.setTrustStorePath(this.trustStorePath);
        }
        if (this.trustStorePassword != null) {
            factory.setTrustStorePassword(this.trustStorePassword);
        }
        factory.setTrustStoreType(this.trustStoreType);
        if (this.trustStoreProvider != null) {
            factory.setTrustStoreProvider(this.trustStoreProvider);
        }
        factory.setValidateCerts(this.validateCerts);
        factory.setValidatePeerCerts(this.validatePeers);
        if (this.supportedProtocols != null) {
            factory.setIncludeProtocols(this.supportedProtocols.toArray(new String[0]));
        }
        if (this.excludedProtocols != null) {
            factory.setExcludeProtocols(this.excludedProtocols.toArray(new String[0]));
        }
        if (this.supportedCipherSuites != null) {
            factory.setIncludeCipherSuites(this.supportedCipherSuites.toArray(new String[0]));
        }
        if (this.excludedCipherSuites != null) {
            factory.setExcludeCipherSuites(this.excludedCipherSuites.toArray(new String[0]));
        }
        if (this.jceProvider != null) {
            factory.setProvider(this.jceProvider);
        }
        return factory;
    }

    @Override
    protected SocketFactory socketFactory() {
        final SslContextFactory sslContextFactory = this.createSslContextFactory();
        try {
            sslContextFactory.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to configure SSLContext", e);
        }
        return new SocketFactory(){

            @Override
            public Socket createSocket() throws IOException {
                return sslContextFactory.newSslSocket();
            }

            @Override
            public Socket createSocket(String host, int port) {
                return this.unsupported();
            }

            @Override
            public Socket createSocket(String host, int port, InetAddress localHost, int localPort) {
                return this.unsupported();
            }

            @Override
            public Socket createSocket(InetAddress host, int port) {
                return this.unsupported();
            }

            @Override
            public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) {
                return this.unsupported();
            }

            private Socket unsupported() {
                throw new UnsupportedOperationException("Only createSocket is supported");
            }
        };
    }
}

