/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.testing;

import java.io.File;
import org.apache.storm.shade.org.apache.commons.io.FileUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmpPath
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(TmpPath.class);
    private final File path;

    public TmpPath() {
        this(TmpPath.localTempPath());
    }

    public TmpPath(String path) {
        this.path = new File(path);
    }

    public static String localTempPath() {
        StringBuilder ret = new StringBuilder().append(System.getProperty("java.io.tmpdir"));
        if (!Utils.isOnWindows()) {
            ret.append("/");
        }
        ret.append(Utils.uuid());
        return ret.toString();
    }

    public String getPath() {
        return this.path.getAbsolutePath();
    }

    public File getFile() {
        return this.path;
    }

    @Override
    public void close() {
        if (this.path.exists()) {
            try {
                FileUtils.forceDelete((File)this.path);
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
            }
        }
    }
}

