/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.policy;

import java.time.Duration;
import org.apache.servicecomb.governance.policy.AbstractPolicy;

public class FaultInjectionPolicy
extends AbstractPolicy {
    public static final Duration DEFAULT_TIMEOUT_DURATION = Duration.ofMillis(0L);
    private String type = "delay";
    private String delayTime = DEFAULT_TIMEOUT_DURATION.toString();
    private int percentage = -1;
    private int errorCode = 500;
    private boolean forceClosed = false;
    private String fallbackType = "ThrowException";

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(String delayTime) {
        this.delayTime = this.stringOfDuration(delayTime, Duration.ofMillis(-1L));
    }

    public int getPercentage() {
        return this.percentage;
    }

    public void setPercentage(int percentage) {
        this.percentage = percentage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public long getDelayTimeToMillis() {
        return Duration.parse(this.delayTime).toMillis();
    }

    public boolean isForceClosed() {
        return this.forceClosed;
    }

    public void setForceClosed(boolean forceClosed) {
        this.forceClosed = forceClosed;
    }

    public String getFallbackType() {
        return this.fallbackType;
    }

    public void setFallbackType(String fallbackType) {
        this.fallbackType = fallbackType;
    }

    @Override
    public boolean isValid() {
        if (this.getDelayTimeToMillis() < 0L && "delay".equals(this.type)) {
            return false;
        }
        if ((this.getErrorCode() < 200 || this.getErrorCode() > 600) && "abort".equals(this.type)) {
            return false;
        }
        return super.isValid();
    }

    public String toString() {
        return "FaultInjectionPolicy{type=" + this.type + ", delayTime=" + this.delayTime + ", percentage=" + this.percentage + ", errorCode=" + this.errorCode + '}';
    }
}

