/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state;

import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.AdaptingIntegerArray;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.ExponentialCounter;

public class AdaptingCircularBufferCounter
implements ExponentialCounter {
    private static final int NULL_INDEX = Integer.MIN_VALUE;
    private int endIndex = Integer.MIN_VALUE;
    private int startIndex = Integer.MIN_VALUE;
    private int baseIndex = Integer.MIN_VALUE;
    private final AdaptingIntegerArray backing;

    public AdaptingCircularBufferCounter(int maxSize) {
        this.backing = new AdaptingIntegerArray(maxSize);
    }

    public AdaptingCircularBufferCounter(ExponentialCounter toCopy) {
        if (toCopy instanceof AdaptingCircularBufferCounter) {
            this.backing = ((AdaptingCircularBufferCounter)toCopy).backing.copy();
            this.startIndex = toCopy.getIndexStart();
            this.endIndex = toCopy.getIndexEnd();
            this.baseIndex = ((AdaptingCircularBufferCounter)toCopy).baseIndex;
        } else {
            this.backing = new AdaptingIntegerArray(toCopy.getMaxSize());
            this.startIndex = Integer.MIN_VALUE;
            this.baseIndex = Integer.MIN_VALUE;
            this.endIndex = Integer.MIN_VALUE;
            for (int i = toCopy.getIndexStart(); i <= toCopy.getIndexEnd(); ++i) {
                long val = toCopy.get(i);
                this.increment(i, val);
            }
        }
    }

    @Override
    public int getIndexStart() {
        return this.startIndex;
    }

    @Override
    public int getIndexEnd() {
        return this.endIndex;
    }

    @Override
    public boolean increment(int index, long delta) {
        if (this.baseIndex == Integer.MIN_VALUE) {
            this.startIndex = index;
            this.endIndex = index;
            this.baseIndex = index;
            this.backing.increment(0, delta);
            return true;
        }
        if (index > this.endIndex) {
            if ((long)index - (long)this.startIndex + 1L > (long)this.backing.length()) {
                return false;
            }
            this.endIndex = index;
        } else if (index < this.startIndex) {
            if ((long)this.endIndex - (long)index + 1L > (long)this.backing.length()) {
                return false;
            }
            this.startIndex = index;
        }
        int realIdx = this.toBufferIndex(index);
        this.backing.increment(realIdx, delta);
        return true;
    }

    @Override
    public long get(int index) {
        if (index < this.startIndex || index > this.endIndex) {
            return 0L;
        }
        return this.backing.get(this.toBufferIndex(index));
    }

    @Override
    public boolean isEmpty() {
        return this.baseIndex == Integer.MIN_VALUE;
    }

    @Override
    public int getMaxSize() {
        return this.backing.length();
    }

    @Override
    public void clear() {
        this.backing.clear();
        this.baseIndex = Integer.MIN_VALUE;
        this.endIndex = Integer.MIN_VALUE;
        this.startIndex = Integer.MIN_VALUE;
    }

    private int toBufferIndex(int index) {
        int result = index - this.baseIndex;
        if (result >= this.backing.length()) {
            result -= this.backing.length();
        } else if (result < 0) {
            result += this.backing.length();
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("{");
        for (int i = this.startIndex; i <= this.endIndex && this.startIndex != Integer.MIN_VALUE; ++i) {
            if (i != this.startIndex) {
                result.append(',');
            }
            result.append(i).append('=').append(this.get(i));
        }
        return result.append("}").toString();
    }
}

