/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.route;

public enum AddressScheme {
    DOMAIN_NAME("dns:"),
    IPv4("ipv4:"),
    IPv6("ipv6:");

    private final String prefix;

    private AddressScheme(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public apache.rocketmq.v2.AddressScheme toProtobuf() {
        switch (this) {
            case IPv4: {
                return apache.rocketmq.v2.AddressScheme.IPv4;
            }
            case IPv6: {
                return apache.rocketmq.v2.AddressScheme.IPv6;
            }
        }
        return apache.rocketmq.v2.AddressScheme.DOMAIN_NAME;
    }

    public static AddressScheme fromPrefix(String prefix) {
        if (DOMAIN_NAME.getPrefix().equals(prefix)) {
            return DOMAIN_NAME;
        }
        if (IPv4.getPrefix().equals(prefix)) {
            return IPv4;
        }
        if (IPv6.getPrefix().equals(prefix)) {
            return IPv6;
        }
        throw new IllegalArgumentException("Unrecognized address scheme prefix: " + prefix);
    }
}

