/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl;

import apache.rocketmq.v2.Settings;
import java.time.Duration;
import org.apache.rocketmq.client.java.impl.ClientType;
import org.apache.rocketmq.client.java.retry.RetryPolicy;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.shaded.com.google.common.base.MoreObjects;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.SettableFuture;

public abstract class ClientSettings {
    protected final String clientId;
    protected final ClientType clientType;
    protected final Endpoints accessPoint;
    protected volatile RetryPolicy retryPolicy;
    protected final Duration requestTimeout;
    protected final SettableFuture<Void> arrivedFuture;

    public ClientSettings(String clientId, ClientType clientType, Endpoints accessPoint, RetryPolicy retryPolicy, Duration requestTimeout) {
        this.clientId = clientId;
        this.clientType = clientType;
        this.accessPoint = accessPoint;
        this.retryPolicy = retryPolicy;
        this.requestTimeout = requestTimeout;
        this.arrivedFuture = SettableFuture.create();
    }

    public ClientSettings(String clientId, ClientType clientType, Endpoints accessPoint, Duration requestTimeout) {
        this(clientId, clientType, accessPoint, null, requestTimeout);
    }

    public abstract Settings toProtobuf();

    public abstract void applySettingsCommand(Settings var1);

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public SettableFuture<Void> getArrivedFuture() {
        return this.arrivedFuture;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("clientId", this.clientId).add("clientType", (Object)this.clientType).add("accessPoint", this.accessPoint).add("retryPolicy", this.retryPolicy).add("requestTimeout", this.requestTimeout).toString();
    }
}

