/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent2.proxy.command;

import java.io.IOException;

import org.apache.commons.chain.Command;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.ProxyMapping;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyException;
import org.apache.portals.applications.webcontent2.proxy.impl.AbstractProxyCommand;
import org.apache.portals.applications.webcontent2.rewriter.ContentRewriter;

/**
 * {@link Command} responsible for resolving the content rewriter
 * from the resolved {@link ProxyMaping} and the content type of the remote content.
 */
public class ResolveContentRewriterCommand extends AbstractProxyCommand
{

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean executeInternal(final ProxyContext context) throws ReverseProxyException, IOException
    {
        HttpResponse httpResponse = context.getHttpResponse();
        HttpEntity httpEntity = httpResponse.getEntity();

        ContentType contentType = ContentType.getOrDefault(httpEntity);
        String mimeType = contentType.getMimeType();

        ProxyMapping resolvedMapping = context.getResolvedMapping();

        ContentRewriter contentRewriter = resolvedMapping.getContentRewriter(mimeType);

        if (contentRewriter != null)
        {
            context.setContentRewriter(contentRewriter);
        }

        return false;
    }

}
