/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent.proxy;

import org.apache.portals.applications.webcontent.rewriter.RewriterController;
import org.apache.portals.applications.webcontent.rewriter.rules.Ruleset;

/**
 * proxy path mapper provider interface for http reverse proxy service.
 * 
 * @version $Id: HttpReverseProxyPathMapperProvider.java 821934 2009-10-05 17:50:07Z woonsan $
 */
public interface HttpReverseProxyPathMapperProvider
{
    
    /**
     * Finds a reverse proxy path mapper based on the path info.
     * @return
     */
    public HttpReverseProxyPathMapper findMapper(String pathInfo);
    
    /**
     * Finds a reverse proxy path mapper based on the remoteURL
     * @return
     */
    public HttpReverseProxyPathMapper findMapperByRemoteURL(String remoteURL);
    
    /**
     * Gets a reverse proxy rewriter controller corresponded to proxy path mapper
     * @return
     */
    public RewriterController getRewriterController(HttpReverseProxyPathMapper proxyPathMapper);
    
    /**
     * Gets a reverse proxy rewriter rules corresponded to proxy path mapper
     * @return
     */
    public Ruleset getRewriterRuleset(HttpReverseProxyPathMapper proxyPathMapper);
    
    /**
     * Returns the maximum matching path part count.
     * @return
     */
    public int getMaxMatchingPathPartCount();
    
}