/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.receivers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.apache.log4j.LogManager;
import org.apache.log4j.chainsaw.help.HelpManager;
import org.apache.log4j.chainsaw.helper.OkCancelPanel;
import org.apache.log4j.chainsaw.messages.MessageCenter;
import org.apache.log4j.chainsaw.receivers.PluginPropertyEditorPanel;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.Receiver;

public class NewReceiverDialogPanel
extends JPanel {
    private PluginPropertyEditorPanel pluginEditorPanel = new PluginPropertyEditorPanel();
    private final OkCancelPanel okPanel = new OkCancelPanel();
    private final JEditorPane javaDocPane = new JEditorPane();
    private final JScrollPane javaDocScroller = new JScrollPane(this.javaDocPane);
    private final JSplitPane splitter = new JSplitPane();

    private NewReceiverDialogPanel() {
        this.setupComponents();
        this.setupListeners();
    }

    private void setupListeners() {
        this.pluginEditorPanel.addPropertyChangeListener("plugin", evt -> {
            Plugin plugin = (Plugin)evt.getNewValue();
            URL url = HelpManager.getInstance().getHelpForClass(plugin.getClass());
            try {
                this.javaDocPane.setPage(url);
            }
            catch (IOException e) {
                MessageCenter.getInstance().getLogger().error("Failed to load the Help resource for " + plugin.getClass(), e);
            }
        });
    }

    private void setupComponents() {
        this.setLayout(new BorderLayout());
        this.setupJavadoc();
        this.setupPluginPropertyPanel();
        this.setupSplitter();
        this.add((Component)this.splitter, "Center");
        this.add((Component)this.okPanel, "South");
        this.setMinimumSize(new Dimension(600, 600));
        this.setPreferredSize(this.getMinimumSize());
    }

    private void setupPluginPropertyPanel() {
        this.pluginEditorPanel.setMinimumSize(new Dimension(320, 160));
        this.pluginEditorPanel.setPreferredSize(this.pluginEditorPanel.getMinimumSize());
    }

    private void setupSplitter() {
        this.splitter.setTopComponent(this.javaDocScroller);
        this.splitter.setBottomComponent(this.pluginEditorPanel);
        this.splitter.setResizeWeight(0.8);
        this.splitter.setOrientation(0);
    }

    private void setupJavadoc() {
        this.javaDocPane.setEditable(false);
    }

    public static NewReceiverDialogPanel create(Class receiverClass) {
        if (!Receiver.class.isAssignableFrom(receiverClass)) {
            throw new IllegalArgumentException(receiverClass.getName() + " is not a Receiver");
        }
        Receiver receiverInstance = null;
        try {
            receiverInstance = (Receiver)receiverClass.newInstance();
        }
        catch (Exception e) {
            LogManager.getLogger(NewReceiverDialogPanel.class).error("Failed to create a new Receiver instance, this exception is unexpected", e);
        }
        NewReceiverDialogPanel panel = new NewReceiverDialogPanel();
        panel.pluginEditorPanel.setPlugin(receiverInstance);
        return panel;
    }

    public final OkCancelPanel getOkPanel() {
        return this.okPanel;
    }

    public Plugin getPlugin() {
        return this.pluginEditorPanel.getPlugin();
    }
}

