/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class CompactAttribute
implements Serializable {
    private static final int MAX_CACHED_NAMES = 1000;
    @NotNull
    private static final ConcurrentHashMap<String, String> cachedNames = new ConcurrentHashMap(StaticUtils.computeMapCapacity(1000));
    private static final long serialVersionUID = 9056952830029621727L;
    @NotNull
    private final byte[][] values;
    @NotNull
    private final String name;

    CompactAttribute(@NotNull Attribute attribute) {
        this.name = CompactAttribute.internName(attribute.getName());
        this.values = attribute.getValueByteArrays();
    }

    @NotNull
    private static String internName(@NotNull String name) {
        String s = cachedNames.get(name);
        if (s == null) {
            if (cachedNames.size() >= 1000) {
                cachedNames.clear();
            }
            cachedNames.put(name, name);
            s = name;
        }
        return s;
    }

    @NotNull
    String getName() {
        return this.name;
    }

    @NotNull
    byte[][] getByteValues() {
        return this.values;
    }

    @NotNull
    String[] getStringValues() {
        String[] stringValues = new String[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            stringValues[i] = StaticUtils.toUTF8String(this.values[i]);
        }
        return stringValues;
    }

    @NotNull
    Attribute toAttribute() {
        return new Attribute(this.name, this.values);
    }
}

