/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.Schema;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.QOM;
import org.jooq.impl.Tools;

abstract class AbstractFunction<T>
extends AbstractField<T>
implements QOM.Function<T> {
    private final boolean applySchemaMapping;

    AbstractFunction(Name name, DataType<T> type, boolean applySchemaMapping) {
        super(name, type);
        this.applySchemaMapping = applySchemaMapping;
    }

    @Override
    public final void accept(Context<?> ctx) {
        QueryPart args = this.arguments();
        switch (ctx.family()) {
            default: 
        }
        AbstractFunction.acceptFunctionName(ctx, this.applySchemaMapping, this.getQualifiedName());
        if (ctx.format() && Tools.isComplex(ctx, args)) {
            ctx.sqlIndentStart('(').visit(args).sqlIndentEnd(')');
        } else {
            ctx.sql('(').visit(args).sql(')');
        }
    }

    static void acceptFunctionName(Context<?> ctx, boolean applySchemaMapping, Name name) {
        if (applySchemaMapping && name.qualified()) {
            Schema mapped = Tools.getMappedSchema(ctx, DSL.schema(name.qualifier()));
            if (mapped != null) {
                ctx.visit(mapped.getQualifiedName().append(name.unqualifiedName()));
            } else {
                ctx.visit(name.unqualifiedName());
            }
        } else {
            ctx.visit(name);
        }
    }

    abstract QueryPart arguments();
}

