/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.SuggestMode;
import org.opensearch.client.opensearch.core.search.FieldSuggester;
import org.opensearch.client.opensearch.core.search.FieldSuggesterVariant;
import org.opensearch.client.opensearch.core.search.StringDistance;
import org.opensearch.client.opensearch.core.search.SuggestSort;
import org.opensearch.client.opensearch.core.search.SuggesterBase;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class TermSuggester
extends SuggesterBase
implements FieldSuggesterVariant {
    @Nullable
    private final Boolean lowercaseTerms;
    @Nullable
    private final Integer maxEdits;
    @Nullable
    private final Integer maxInspections;
    @Nullable
    private final Float maxTermFreq;
    @Nullable
    private final Float minDocFreq;
    @Nullable
    private final Integer minWordLength;
    @Nullable
    private final Integer prefixLength;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final SuggestSort sort;
    @Nullable
    private final StringDistance stringDistance;
    @Nullable
    private final SuggestMode suggestMode;
    @Nullable
    private final String text;
    public static final JsonpDeserializer<TermSuggester> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermSuggester::setupTermSuggesterDeserializer);

    private TermSuggester(Builder builder) {
        super(builder);
        this.lowercaseTerms = builder.lowercaseTerms;
        this.maxEdits = builder.maxEdits;
        this.maxInspections = builder.maxInspections;
        this.maxTermFreq = builder.maxTermFreq;
        this.minDocFreq = builder.minDocFreq;
        this.minWordLength = builder.minWordLength;
        this.prefixLength = builder.prefixLength;
        this.shardSize = builder.shardSize;
        this.sort = builder.sort;
        this.stringDistance = builder.stringDistance;
        this.suggestMode = builder.suggestMode;
        this.text = builder.text;
    }

    public static TermSuggester of(Function<Builder, ObjectBuilder<TermSuggester>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public FieldSuggester.Kind _fieldSuggesterKind() {
        return FieldSuggester.Kind.Term;
    }

    @Nullable
    public final Boolean lowercaseTerms() {
        return this.lowercaseTerms;
    }

    @Nullable
    public final Integer maxEdits() {
        return this.maxEdits;
    }

    @Nullable
    public final Integer maxInspections() {
        return this.maxInspections;
    }

    @Nullable
    public final Float maxTermFreq() {
        return this.maxTermFreq;
    }

    @Nullable
    public final Float minDocFreq() {
        return this.minDocFreq;
    }

    @Nullable
    public final Integer minWordLength() {
        return this.minWordLength;
    }

    @Nullable
    public final Integer prefixLength() {
        return this.prefixLength;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public final SuggestSort sort() {
        return this.sort;
    }

    @Nullable
    public final StringDistance stringDistance() {
        return this.stringDistance;
    }

    @Nullable
    public final SuggestMode suggestMode() {
        return this.suggestMode;
    }

    @Nullable
    public final String text() {
        return this.text;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.lowercaseTerms != null) {
            generator.writeKey("lowercase_terms");
            generator.write(this.lowercaseTerms.booleanValue());
        }
        if (this.maxEdits != null) {
            generator.writeKey("max_edits");
            generator.write(this.maxEdits.intValue());
        }
        if (this.maxInspections != null) {
            generator.writeKey("max_inspections");
            generator.write(this.maxInspections.intValue());
        }
        if (this.maxTermFreq != null) {
            generator.writeKey("max_term_freq");
            generator.write((double)this.maxTermFreq.floatValue());
        }
        if (this.minDocFreq != null) {
            generator.writeKey("min_doc_freq");
            generator.write((double)this.minDocFreq.floatValue());
        }
        if (this.minWordLength != null) {
            generator.writeKey("min_word_length");
            generator.write(this.minWordLength.intValue());
        }
        if (this.prefixLength != null) {
            generator.writeKey("prefix_length");
            generator.write(this.prefixLength.intValue());
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            this.sort.serialize(generator, mapper);
        }
        if (this.stringDistance != null) {
            generator.writeKey("string_distance");
            this.stringDistance.serialize(generator, mapper);
        }
        if (this.suggestMode != null) {
            generator.writeKey("suggest_mode");
            this.suggestMode.serialize(generator, mapper);
        }
        if (this.text != null) {
            generator.writeKey("text");
            generator.write(this.text);
        }
    }

    protected static void setupTermSuggesterDeserializer(ObjectDeserializer<Builder> op) {
        SuggesterBase.setupSuggesterBaseDeserializer(op);
        op.add(Builder::lowercaseTerms, JsonpDeserializer.booleanDeserializer(), "lowercase_terms");
        op.add(Builder::maxEdits, JsonpDeserializer.integerDeserializer(), "max_edits");
        op.add(Builder::maxInspections, JsonpDeserializer.integerDeserializer(), "max_inspections");
        op.add(Builder::maxTermFreq, JsonpDeserializer.floatDeserializer(), "max_term_freq");
        op.add(Builder::minDocFreq, JsonpDeserializer.floatDeserializer(), "min_doc_freq");
        op.add(Builder::minWordLength, JsonpDeserializer.integerDeserializer(), "min_word_length");
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length");
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
        op.add(Builder::sort, SuggestSort._DESERIALIZER, "sort");
        op.add(Builder::stringDistance, StringDistance._DESERIALIZER, "string_distance");
        op.add(Builder::suggestMode, SuggestMode._DESERIALIZER, "suggest_mode");
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
    }

    public static class Builder
    extends SuggesterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TermSuggester> {
        @Nullable
        private Boolean lowercaseTerms;
        @Nullable
        private Integer maxEdits;
        @Nullable
        private Integer maxInspections;
        @Nullable
        private Float maxTermFreq;
        @Nullable
        private Float minDocFreq;
        @Nullable
        private Integer minWordLength;
        @Nullable
        private Integer prefixLength;
        @Nullable
        private Integer shardSize;
        @Nullable
        private SuggestSort sort;
        @Nullable
        private StringDistance stringDistance;
        @Nullable
        private SuggestMode suggestMode;
        @Nullable
        private String text;

        public final Builder lowercaseTerms(@Nullable Boolean value) {
            this.lowercaseTerms = value;
            return this;
        }

        public final Builder maxEdits(@Nullable Integer value) {
            this.maxEdits = value;
            return this;
        }

        public final Builder maxInspections(@Nullable Integer value) {
            this.maxInspections = value;
            return this;
        }

        public final Builder maxTermFreq(@Nullable Float value) {
            this.maxTermFreq = value;
            return this;
        }

        public final Builder minDocFreq(@Nullable Float value) {
            this.minDocFreq = value;
            return this;
        }

        public final Builder minWordLength(@Nullable Integer value) {
            this.minWordLength = value;
            return this;
        }

        public final Builder prefixLength(@Nullable Integer value) {
            this.prefixLength = value;
            return this;
        }

        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        public final Builder sort(@Nullable SuggestSort value) {
            this.sort = value;
            return this;
        }

        public final Builder stringDistance(@Nullable StringDistance value) {
            this.stringDistance = value;
            return this;
        }

        public final Builder suggestMode(@Nullable SuggestMode value) {
            this.suggestMode = value;
            return this;
        }

        public final Builder text(@Nullable String value) {
            this.text = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TermSuggester build() {
            this._checkSingleUse();
            return new TermSuggester(this);
        }
    }
}

