/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.request;

import jakarta.mail.Flags;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.message.request.AbstractImapRequest;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.util.StreamUtils;

public class StoreRequest
extends AbstractImapRequest {
    private final IdRange[] idSet;
    private final Flags flags;
    private final boolean useUids;
    private final boolean silent;
    private final MessageManager.FlagsUpdateMode flagsUpdateMode;
    private final long unchangedSince;

    public StoreRequest(IdRange[] idSet, boolean silent, Flags flags, boolean useUids, Tag tag, MessageManager.FlagsUpdateMode flagsUpdateMode, long unchangedSince) {
        super(tag, ImapConstants.STORE_COMMAND);
        this.idSet = idSet;
        this.silent = silent;
        this.flags = flags;
        this.useUids = useUids;
        this.flagsUpdateMode = flagsUpdateMode;
        this.unchangedSince = unchangedSince;
    }

    public final boolean isSilent() {
        return this.silent;
    }

    public final MessageManager.FlagsUpdateMode getFlagsUpdateMode() {
        return this.flagsUpdateMode;
    }

    public final Flags getFlags() {
        return this.flags;
    }

    public final IdRange[] getIdSet() {
        return this.idSet;
    }

    public final boolean isUseUids() {
        return this.useUids;
    }

    public final long getUnchangedSince() {
        return this.unchangedSince;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(100);
        if (this.isUseUids()) {
            builder.append("UID ");
        }
        builder.append("STORE ");
        StreamUtils.ofNullable((Object[])this.idSet).map(range -> " " + range.asString()).forEach(builder::append);
        if (this.isSilent()) {
            builder.append("SILENT ");
        }
        if (this.flagsUpdateMode == MessageManager.FlagsUpdateMode.ADD) {
            builder.append("+ ");
        }
        if (this.flagsUpdateMode == MessageManager.FlagsUpdateMode.REMOVE) {
            builder.append("- ");
        }
        if (this.flags.contains(Flags.Flag.ANSWERED)) {
            builder.append(" ANSWERED");
        }
        if (this.flags.contains(Flags.Flag.DELETED)) {
            builder.append(" DELETED");
        }
        if (this.flags.contains(Flags.Flag.FLAGGED)) {
            builder.append(" FLAGGED");
        }
        if (this.flags.contains(Flags.Flag.DRAFT)) {
            builder.append(" DRAFT");
        }
        if (this.flags.contains(Flags.Flag.SEEN)) {
            builder.append(" SEEN");
        }
        if (this.flags.contains(Flags.Flag.RECENT)) {
            builder.append(" RECENT");
        }
        StreamUtils.ofNullable((Object[])this.flags.getUserFlags()).map(flag -> flag + " ").forEach(builder::append);
        return builder.toString();
    }
}

