/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.memory.projections;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.james.jmap.api.projections.MessageFastViewPrecomputedProperties;
import org.apache.james.jmap.api.projections.MessageFastViewProjection;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import reactor.core.publisher.Mono;

public class MemoryMessageFastViewProjection
implements MessageFastViewProjection {
    private final ConcurrentHashMap<MessageId, MessageFastViewPrecomputedProperties> projectionItems = new ConcurrentHashMap();
    private final Metric metricRetrieveHitCount;
    private final Metric metricRetrieveMissCount;

    @Inject
    public MemoryMessageFastViewProjection(MetricFactory metricFactory) {
        this.metricRetrieveHitCount = metricFactory.generate("MessageFastViewProjection:retrieveHitCount");
        this.metricRetrieveMissCount = metricFactory.generate("MessageFastViewProjection:retrieveMissCount");
    }

    public Mono<Void> store(MessageId messageId, MessageFastViewPrecomputedProperties precomputedProperties) {
        Preconditions.checkNotNull((Object)messageId);
        Preconditions.checkNotNull((Object)precomputedProperties);
        return Mono.fromRunnable(() -> this.projectionItems.put(messageId, precomputedProperties));
    }

    public Mono<MessageFastViewPrecomputedProperties> retrieve(MessageId messageId) {
        Preconditions.checkNotNull((Object)messageId);
        return Mono.fromSupplier(() -> this.projectionItems.get(messageId)).doOnNext(preview -> this.metricRetrieveHitCount.increment()).switchIfEmpty(Mono.fromRunnable(() -> ((Metric)this.metricRetrieveMissCount).increment()));
    }

    public Mono<Void> delete(MessageId messageId) {
        Preconditions.checkNotNull((Object)messageId);
        return Mono.fromRunnable(() -> this.projectionItems.remove(messageId));
    }

    public Mono<Void> clear() {
        return Mono.fromRunnable(this.projectionItems::clear);
    }
}

