/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.lambdas;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Chainer<N, T extends N, C extends Chainer<N, T, C>> {
    private static final Map<Class<? extends RuntimeException>, MethodHandle> HANDLES = new ConcurrentHashMap<Class<? extends RuntimeException>, MethodHandle>();
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
    private static final MethodType TYPE = MethodType.methodType(Void.TYPE, Throwable.class);
    protected final T throwing;

    private static MethodHandle getHandle(Class<? extends RuntimeException> c) {
        return HANDLES.computeIfAbsent(c, key -> {
            try {
                return LOOKUP.findConstructor(c, TYPE).asType(TYPE.changeReturnType(RuntimeException.class));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new InstantiationException(e);
            }
        });
    }

    protected static <E extends RuntimeException> E rethrow(Class<E> c, Throwable t2) {
        try {
            return (E)Chainer.getHandle(c).invokeExact(t2);
        }
        catch (InstantiationException e) {
            e.addSuppressed(t2);
            throw e;
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable oops) {
            InstantiationException exception = new InstantiationException(oops);
            exception.addSuppressed(t2);
            throw exception;
        }
    }

    protected static RuntimeException doSneakyThrow(Throwable throwable) {
        Objects.requireNonNull(throwable);
        Chainer.doSneakyThrow0(throwable);
        return null;
    }

    private static <T extends Throwable> T doSneakyThrow0(Throwable throwable) throws T {
        throw throwable;
    }

    protected Chainer(T throwing) {
        this.throwing = throwing;
    }

    public abstract C orTryWith(T var1);

    public abstract <E extends RuntimeException> T orThrow(Class<E> var1);

    public abstract N fallbackTo(N var1);

    public abstract N sneakyThrow();

    public static final class InstantiationException
    extends RuntimeException {
        InstantiationException(Throwable cause) {
            super(cause);
        }
    }
}

