/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.decoder;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.tsfile.common.bitStream.BitInputStream;
import org.apache.tsfile.common.bitStream.ByteBufferBackedInputStream;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.exception.encoding.TsFileDecodingException;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;

public class CamelDecoder
extends Decoder {
    private static final int BITS_FOR_SIGN = 1;
    private static final int BITS_FOR_TYPE = 1;
    private static final int BITS_FOR_FIRST_VALUE = 64;
    private static final int BITS_FOR_LEADING_ZEROS = 6;
    private static final int BITS_FOR_SIGNIFICANT_BITS = 6;
    private static final int BITS_FOR_DECIMAL_COUNT = 4;
    private static final int DOUBLE_TOTAL_BITS = 64;
    private static final int DOUBLE_MANTISSA_BITS = 52;
    private static final int DECIMAL_MAX_COUNT = 15;
    private long previousValue = 0L;
    private boolean isFirst = true;
    private long storedVal = 0L;
    private double scale;
    public static final long[] powers = new long[15];
    public static final long[] threshold = new long[15];
    private BitInputStream in;
    private final GorillaDecoder gorillaDecoder;
    private double[] valueCache = new double[0];
    private int cacheIndex = 0;
    private int cacheSize = 0;
    private double[] valuesBuffer = new double[16];

    public CamelDecoder(InputStream inputStream, long totalBits) {
        super(TSEncoding.CAMEL);
        this.in = new BitInputStream(inputStream, totalBits);
        this.gorillaDecoder = new GorillaDecoder();
    }

    public CamelDecoder() {
        super(TSEncoding.CAMEL);
        this.gorillaDecoder = new GorillaDecoder();
    }

    @Override
    public boolean hasNext(ByteBuffer buffer) throws IOException {
        if (this.cacheIndex < this.cacheSize) {
            return true;
        }
        if (this.in != null && this.in.availableBits() > 0) {
            return true;
        }
        return buffer.hasRemaining();
    }

    @Override
    public void reset() {
        this.in = null;
        this.isFirst = true;
        this.previousValue = 0L;
        this.storedVal = 0L;
        this.gorillaDecoder.leadingZeros = Integer.MAX_VALUE;
        this.gorillaDecoder.trailingZeros = 0;
    }

    @Override
    public double readDouble(ByteBuffer buffer) {
        try {
            if (this.cacheIndex >= this.cacheSize && (this.in == null || this.in.availableBits() == 0)) {
                if (!buffer.hasRemaining()) {
                    throw new TsFileDecodingException("No more data to decode");
                }
                ByteBuffer slice = buffer.slice();
                ByteBufferBackedInputStream bais = new ByteBufferBackedInputStream(slice);
                int blockBits = ReadWriteForEncodingUtils.readVarInt(bais);
                this.in = new BitInputStream(bais, blockBits);
                this.isFirst = true;
                this.storedVal = 0L;
                this.previousValue = 0L;
                this.gorillaDecoder.leadingZeros = Integer.MAX_VALUE;
                this.gorillaDecoder.trailingZeros = 0;
                double[] newValues = this.getValues();
                if (newValues.length == 0) {
                    throw new TsFileDecodingException("Unexpected empty block");
                }
                this.valueCache = newValues;
                this.cacheSize = newValues.length;
                this.cacheIndex = 0;
                int consumed = bais.getConsumed();
                buffer.position(buffer.position() + consumed);
            }
            return this.valueCache[this.cacheIndex++];
        }
        catch (IOException e) {
            throw new TsFileDecodingException(e.getMessage());
        }
    }

    public GorillaDecoder getGorillaDecoder() {
        return this.gorillaDecoder;
    }

    public double[] getValues() throws IOException {
        int count = 0;
        while (this.in.availableBits() > 0) {
            double val = this.next();
            if (count == this.valuesBuffer.length) {
                this.valuesBuffer = Arrays.copyOf(this.valuesBuffer, this.valuesBuffer.length * 2);
            }
            this.valuesBuffer[count++] = val;
        }
        return Arrays.copyOf(this.valuesBuffer, count);
    }

    private double next() throws IOException {
        double result;
        if (this.isFirst) {
            this.isFirst = false;
            long firstBits = this.in.readLong(64);
            result = Double.longBitsToDouble(firstBits);
            this.storedVal = (long)result;
        } else {
            result = this.nextValue();
        }
        this.previousValue = Double.doubleToLongBits(result);
        return result;
    }

    private double nextValue() throws IOException {
        boolean useCamel;
        int signBit = this.in.readInt(1);
        double sign = signBit == 1 ? -1.0 : 1.0;
        int typeBit = this.in.readInt(1);
        boolean bl = useCamel = typeBit == 1;
        if (useCamel) {
            long intPart = this.readLong();
            double decPart = this.readDecimal();
            double value = intPart >= 0L ? ((double)intPart * this.scale + decPart) / this.scale : -((double)intPart * this.scale + decPart) / this.scale;
            return sign * value;
        }
        return sign * this.gorillaDecoder.decode(this.in);
    }

    private long readLong() throws IOException {
        long diff = BitInputStream.readVarLong(this.in);
        this.storedVal += diff;
        return this.storedVal;
    }

    private double readDecimal() throws IOException {
        double frac;
        int count = this.in.readInt(4) + 1;
        boolean hasXor = this.in.readBit();
        long xor = 0L;
        if (hasXor) {
            long bits = this.in.readLong(count);
            xor = bits << 52 - count;
        }
        long mVal = BitInputStream.readVarLong(this.in);
        if (hasXor) {
            double base = (double)mVal / (double)powers[count - 1] + 1.0;
            long merged = xor ^ Double.doubleToLongBits(base);
            frac = Double.longBitsToDouble(merged) - 1.0;
        } else {
            frac = (double)mVal / (double)powers[count - 1];
        }
        this.scale = Math.pow(10.0, count);
        return Math.round(frac * this.scale);
    }

    static {
        for (int l = 1; l <= 15; ++l) {
            int idx = l - 1;
            CamelDecoder.powers[idx] = (long)Math.pow(10.0, l);
            long divisor = 1L << l;
            CamelDecoder.threshold[idx] = powers[idx] / divisor;
        }
    }

    public class GorillaDecoder {
        private int leadingZeros = Integer.MAX_VALUE;
        private int trailingZeros = 0;

        public double decode(BitInputStream in) throws IOException {
            long xor;
            boolean reuseBlock;
            if (CamelDecoder.this.isFirst) {
                CamelDecoder.this.previousValue = in.readLong(64);
                CamelDecoder.this.isFirst = false;
                return Double.longBitsToDouble(CamelDecoder.this.previousValue);
            }
            boolean controlBit = in.readBit();
            if (!controlBit) {
                return Double.longBitsToDouble(CamelDecoder.this.previousValue);
            }
            boolean bl = reuseBlock = !in.readBit();
            if (reuseBlock) {
                int sigBits = 64 - this.leadingZeros - this.trailingZeros;
                if (sigBits == 0) {
                    return Double.longBitsToDouble(CamelDecoder.this.previousValue);
                }
                xor = in.readLong(sigBits) << this.trailingZeros;
            } else {
                this.leadingZeros = in.readInt(6);
                int sigBits = in.readInt(6) + 1;
                this.trailingZeros = 64 - this.leadingZeros - sigBits;
                xor = in.readLong(sigBits) << this.trailingZeros;
            }
            CamelDecoder.this.previousValue ^= xor;
            return Double.longBitsToDouble(CamelDecoder.this.previousValue);
        }
    }
}

