/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.UnaryTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class ReplaceFunctionTransformer
extends UnaryTransformer {
    private final String from;
    private final String to;

    public ReplaceFunctionTransformer(LayerReader layerReader, String from, String to) {
        super(layerReader);
        this.from = from;
        this.to = to;
        if (this.layerReaderDataType != TSDataType.TEXT) {
            throw new UnSupportedDataTypeException("Unsupported data type: " + this.layerReaderDataType);
        }
    }

    @Override
    public TSDataType[] getDataTypes() {
        return new TSDataType[]{TSDataType.TEXT};
    }

    @Override
    public void transform(Column[] columns, ColumnBuilder builder) {
        int count = columns[0].getPositionCount();
        Binary[] binaries = columns[0].getBinaries();
        boolean[] isNulls = columns[0].isNull();
        for (int i = 0; i < count; ++i) {
            if (!isNulls[i]) {
                String res = binaries[i].getStringValue(TSFileConfig.STRING_CHARSET).replace(this.from, this.to);
                Binary bin = BytesUtils.valueOf((String)res);
                builder.writeBinary(bin);
                continue;
            }
            builder.appendNull();
        }
    }
}

