/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.tx;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite3.internal.sql.engine.exec.TransactionalOperationTracker;
import org.apache.ignite3.internal.sql.engine.tx.QueryTransactionWrapper;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.util.CompletableFutures;

public class QueryTransactionWrapperImpl
implements QueryTransactionWrapper {
    private final boolean queryImplicit;
    private final InternalTransaction transaction;
    private final TransactionalOperationTracker txTracker;
    private final AtomicBoolean committed = new AtomicBoolean();

    public QueryTransactionWrapperImpl(InternalTransaction transaction, boolean implicit, TransactionalOperationTracker txTracker) {
        this.transaction = transaction;
        this.queryImplicit = implicit;
        this.txTracker = txTracker;
    }

    @Override
    public InternalTransaction unwrap() {
        return this.transaction;
    }

    @Override
    public CompletableFuture<Void> finalise() {
        if (this.committed.compareAndSet(false, true)) {
            this.txTracker.registerOperationFinish(this.transaction);
        }
        if (this.queryImplicit) {
            return this.transaction.commitAsync();
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> finalise(Throwable error) {
        assert (error != null);
        if (this.committed.compareAndSet(false, true)) {
            this.txTracker.registerOperationFinish(this.transaction);
        }
        if (this.transaction.remote()) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.transaction.rollbackAsync();
    }

    @Override
    public boolean implicit() {
        return this.queryImplicit;
    }
}

