/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql;

import java.util.List;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.ignite3.internal.sql.engine.sql.ParseMode;
import org.apache.ignite3.internal.sql.engine.sql.ParseResult;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.SqlException;

public final class StatementParseResult
extends ParseResult {
    public static final ParseMode<StatementParseResult> MODE = new ParseMode<StatementParseResult>(){

        @Override
        StatementParseResult createResult(List<SqlNode> list, int dynamicParamsCount) {
            if (list.size() > 1) {
                throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Multiple statements are not allowed.");
            }
            return new StatementParseResult(list.get(0), dynamicParamsCount);
        }
    };
    private final SqlNode statement;

    StatementParseResult(SqlNode sqlNode, int dynamicParamsCount) {
        super(dynamicParamsCount);
        assert (!(sqlNode instanceof SqlNodeList)) : "Can not create a statement result from a node list: " + sqlNode;
        this.statement = sqlNode;
    }

    public SqlNode statement() {
        return this.statement;
    }

    public String toString() {
        return S.toString(StatementParseResult.class, this, "statement", (Object)this.statement());
    }
}

