/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlKillObjectType;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlSpecialOperator;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlKill
extends SqlCall {
    private final Operator operator;

    public IgniteSqlKill(SqlParserPos pos, IgniteSqlKillObjectType objectType, SqlLiteral objectId, @Nullable Boolean noWait) {
        super(pos);
        this.operator = new Operator(objectType, objectId, noWait);
    }

    public SqlLiteral objectId() {
        return this.operator.objectId;
    }

    public IgniteSqlKillObjectType objectType() {
        return this.operator.objectType;
    }

    @Nullable
    public Boolean noWait() {
        return this.operator.noWait;
    }

    public SqlOperator getOperator() {
        return this.operator;
    }

    public List<SqlNode> getOperandList() {
        return List.of(this.operator.objectId);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getOperator().getName());
        writer.keyword(this.objectType().name());
        this.objectId().unparse(writer, leftPrec, rightPrec);
        if (this.operator.noWait != null && this.operator.noWait.booleanValue()) {
            writer.keyword("NO");
            writer.keyword("WAIT");
        }
    }

    protected static class Operator
    extends IgniteSqlSpecialOperator {
        private final IgniteSqlKillObjectType objectType;
        private final SqlLiteral objectId;
        @Nullable
        private final Boolean noWait;

        protected Operator(IgniteSqlKillObjectType objectType, SqlLiteral objectId, @Nullable Boolean noWait) {
            super("KILL", SqlKind.OTHER);
            this.objectType = Objects.requireNonNull(objectType, "objectType");
            this.objectId = Objects.requireNonNull(objectId, "objectId");
            this.noWait = noWait;
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlKill(pos, this.objectType, (SqlLiteral)operands[0], this.noWait);
        }
    }
}

