/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.sql.exception.handler;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import jakarta.inject.Singleton;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.constants.HttpCode;
import org.apache.ignite3.internal.rest.problem.HttpProblemResponse;
import org.apache.ignite3.internal.rest.sql.exception.SqlQueryNotFoundException;

@Singleton
@Requires(classes={SqlQueryNotFoundExceptionHandler.class, ExceptionHandler.class})
public class SqlQueryNotFoundExceptionHandler
implements ExceptionHandler<SqlQueryNotFoundException, HttpResponse<? extends Problem>> {
    public HttpResponse<? extends Problem> handle(HttpRequest request, SqlQueryNotFoundException exception) {
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.NOT_FOUND).detail(exception.getMessage()).build());
    }
}

