/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.ColumnParams;
import org.apache.ignite3.internal.catalog.commands.CreateTableCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.TableHashPrimaryKey;
import org.apache.ignite3.internal.catalog.commands.TablePrimaryKey;
import org.apache.ignite3.internal.catalog.commands.TableSortedPrimaryKey;
import org.apache.ignite3.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite3.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite3.internal.catalog.storage.NewIndexEntry;
import org.apache.ignite3.internal.catalog.storage.NewTableEntry;
import org.apache.ignite3.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class CreateTableCommand
extends AbstractTableCommand {
    private final TablePrimaryKey primaryKey;
    private final List<String> colocationColumns;
    private final List<ColumnParams> columns;
    private final String zoneName;
    private String storageProfile;

    public static CreateTableCommandBuilder builder() {
        return new Builder();
    }

    private CreateTableCommand(String tableName, String schemaName, boolean ifNotExists, TablePrimaryKey primaryKey, List<String> colocationColumns, List<ColumnParams> columns, @Nullable String zoneName, String storageProfile, boolean validateSystemSchemas) throws CatalogValidationException {
        super(schemaName, tableName, ifNotExists, validateSystemSchemas);
        this.primaryKey = primaryKey;
        this.colocationColumns = CollectionUtils.copyOrNull(colocationColumns);
        this.columns = CollectionUtils.copyOrNull(columns);
        this.zoneName = zoneName;
        this.storageProfile = storageProfile;
        this.validate();
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        CatalogZoneDescriptor zone;
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, this.schemaName);
        if (this.ifTableExists && schema.table(this.tableName) != null) {
            return List.of();
        }
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, this.tableName);
        if (this.zoneName == null) {
            if (catalog.defaultZone() == null) {
                throw new CatalogValidationException("The zone is not specified. Please specify zone explicitly or set default one.");
            }
            zone = catalog.defaultZone();
        } else {
            zone = CatalogUtils.zone(catalog, this.zoneName, true);
        }
        if (this.storageProfile == null) {
            this.storageProfile = zone.storageProfiles().defaultProfile().storageProfile();
        }
        CatalogParamsValidationUtils.ensureZoneContainsTablesStorageProfile(zone, this.storageProfile);
        int id = catalog.objectIdGenState();
        int tableId = id++;
        int pkIndexId = id++;
        CatalogTableDescriptor table = CatalogTableDescriptor.builder().id(tableId).schemaId(schema.id()).primaryKeyIndexId(pkIndexId).name(this.tableName).zoneId(zone.id()).columns(this.columns.stream().map(CatalogUtils::fromParams).collect(Collectors.toList())).primaryKeyColumns(this.primaryKey.columns()).colocationColumns(this.colocationColumns).storageProfile(this.storageProfile).build();
        String indexName = this.primaryKey.name();
        if (indexName == null) {
            indexName = CatalogUtils.pkIndexName(this.tableName);
        }
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, indexName);
        CatalogIndexDescriptor pkIndex = this.createPkIndexDescriptor(indexName, pkIndexId, tableId);
        return List.of(new NewTableEntry(table), new NewIndexEntry(pkIndex), new ObjectIdGenUpdateEntry(id - catalog.objectIdGenState()));
    }

    private void validate() {
        if (CollectionUtils.nullOrEmpty(this.columns)) {
            throw new CatalogValidationException("Table should have at least one column.");
        }
        HashSet<String> columnNames = new HashSet<String>();
        for (ColumnParams column : this.columns) {
            if (columnNames.add(column.name())) continue;
            throw new CatalogValidationException("Column with name '{}' specified more than once.", column.name());
        }
        if (this.primaryKey == null || CollectionUtils.nullOrEmpty(this.primaryKey.columns())) {
            throw new CatalogValidationException("Table should have primary key.");
        }
        this.primaryKey.validate(this.columns);
        for (ColumnParams column : this.columns) {
            boolean partOfPk = this.primaryKey.columns().contains(column.name());
            CatalogUtils.ensureTypeCanBeStored(column.name(), column.type());
            if (partOfPk) {
                CatalogUtils.ensureSupportedDefault(column.name(), column.type(), column.defaultValueDefinition());
                continue;
            }
            CatalogUtils.ensureNonFunctionalDefault(column.name(), column.defaultValueDefinition());
        }
        if (CollectionUtils.nullOrEmpty(this.colocationColumns)) {
            throw new CatalogValidationException("Colocation columns could not be empty.");
        }
        HashSet<String> colocationColumnsSet = new HashSet<String>();
        for (String name : this.colocationColumns) {
            if (!this.primaryKey.columns().contains(name)) {
                throw new CatalogValidationException("Colocation column '{}' is not part of PK.", name);
            }
            if (colocationColumnsSet.add(name)) continue;
            throw new CatalogValidationException("Colocation column '{}' specified more that once", name);
        }
    }

    private CatalogIndexDescriptor createPkIndexDescriptor(String indexName, int pkIndexId, int tableId) {
        CatalogIndexDescriptor pkIndex;
        if (this.primaryKey instanceof TableSortedPrimaryKey) {
            TableSortedPrimaryKey sortedPrimaryKey = (TableSortedPrimaryKey)this.primaryKey;
            ArrayList<CatalogIndexColumnDescriptor> indexColumns = new ArrayList<CatalogIndexColumnDescriptor>(sortedPrimaryKey.columns().size());
            for (int i = 0; i < sortedPrimaryKey.columns().size(); ++i) {
                String columnName = sortedPrimaryKey.columns().get(i);
                CatalogColumnCollation collation = sortedPrimaryKey.collations().get(i);
                indexColumns.add(new CatalogIndexColumnDescriptor(columnName, collation));
            }
            pkIndex = new CatalogSortedIndexDescriptor(pkIndexId, indexName, tableId, true, CatalogIndexStatus.AVAILABLE, indexColumns, true);
        } else if (this.primaryKey instanceof TableHashPrimaryKey) {
            TableHashPrimaryKey hashPrimaryKey = (TableHashPrimaryKey)this.primaryKey;
            pkIndex = new CatalogHashIndexDescriptor(pkIndexId, indexName, tableId, true, CatalogIndexStatus.AVAILABLE, hashPrimaryKey.columns(), true);
        } else {
            throw new IllegalArgumentException("Unexpected primary key type: " + this.primaryKey);
        }
        return pkIndex;
    }

    private static class Builder
    implements CreateTableCommandBuilder {
        private List<ColumnParams> columns;
        private String schemaName;
        private String tableName;
        private boolean ifNotExists;
        private TablePrimaryKey primaryKey;
        private List<String> colocationColumns;
        private String zoneName;
        private String storageProfile;
        private boolean validateSystemSchemas = true;

        private Builder() {
        }

        @Override
        public CreateTableCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public CreateTableCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public CreateTableCommandBuilder ifTableExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        @Override
        public CreateTableCommandBuilder columns(List<ColumnParams> columns) {
            this.columns = columns;
            return this;
        }

        @Override
        public CreateTableCommandBuilder primaryKey(TablePrimaryKey primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        @Override
        public CreateTableCommandBuilder colocationColumns(List<String> colocationColumns) {
            this.colocationColumns = colocationColumns;
            return this;
        }

        @Override
        public CreateTableCommandBuilder zone(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        @Override
        public CreateTableCommandBuilder storageProfile(String storageProfile) {
            this.storageProfile = storageProfile;
            return this;
        }

        @Override
        public CreateTableCommandBuilder validateSystemSchemas(boolean validateSystemSchemas) {
            this.validateSystemSchemas = validateSystemSchemas;
            return this;
        }

        @Override
        public CatalogCommand build() {
            List<String> colocationColumns = this.colocationColumns != null ? this.colocationColumns : (this.primaryKey != null ? this.primaryKey.columns() : null);
            return new CreateTableCommand(this.tableName, this.schemaName, this.ifNotExists, this.primaryKey, colocationColumns, this.columns, this.zoneName, this.storageProfile, this.validateSystemSchemas);
        }
    }
}

