/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.compute;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite3.client.handler.ClientContext;
import org.apache.ignite3.client.handler.NotificationSender;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.client.handler.requests.cluster.ClientClusterGetNodesRequest;
import org.apache.ignite3.client.handler.requests.compute.ClientComputeGetStateRequest;
import org.apache.ignite3.compute.JobExecution;
import org.apache.ignite3.compute.NodeNotFoundException;
import org.apache.ignite3.internal.client.proto.ClientComputeJobPacker;
import org.apache.ignite3.internal.client.proto.ClientComputeJobUnpacker;
import org.apache.ignite3.internal.client.proto.ClientMessagePacker;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.client.proto.ProtocolBitmaskFeature;
import org.apache.ignite3.internal.compute.ComputeJobDataHolder;
import org.apache.ignite3.internal.compute.ExecutionContext;
import org.apache.ignite3.internal.compute.IgniteComputeInternal;
import org.apache.ignite3.internal.compute.MarshallerProvider;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadata;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadataBuilder;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.marshalling.Marshaller;
import org.apache.ignite3.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class ClientComputeExecuteRequest {
    private static final IgniteLogger LOG = Loggers.forClass(ClientComputeExecuteRequest.class);

    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteComputeInternal compute, ClusterService cluster, NotificationSender notificationSender, ClientContext clientContext) {
        Set<InternalClusterNode> candidates = ClientComputeExecuteRequest.unpackCandidateNodes(in, cluster);
        ClientComputeJobUnpacker.Job job = ClientComputeJobUnpacker.unpackJob(in, clientContext.hasFeature(ProtocolBitmaskFeature.PLATFORM_COMPUTE_JOB));
        UUID taskId = ClientComputeJobUnpacker.unpackTaskId(in, clientContext.hasFeature(ProtocolBitmaskFeature.COMPUTE_TASK_ID));
        ComputeEventMetadataBuilder metadataBuilder = ComputeEventMetadata.builder(taskId != null ? ComputeEventMetadata.Type.BROADCAST : ComputeEventMetadata.Type.SINGLE).eventUser(clientContext.userDetails()).taskId(taskId).clientAddress(clientContext.remoteAddress().toString());
        CompletableFuture<JobExecution<ComputeJobDataHolder>> executionFut = compute.executeAsyncWithFailover(candidates, new ExecutionContext(job.options(), job.deploymentUnits(), job.jobClassName(), metadataBuilder, job.arg()), null);
        ClientComputeExecuteRequest.sendResultAndState(executionFut, notificationSender);
        return executionFut.thenCompose(execution -> execution.idAsync().thenApply(jobId -> out -> ClientComputeExecuteRequest.packSubmitResult(out, jobId, execution.node())));
    }

    private static Set<InternalClusterNode> unpackCandidateNodes(ClientMessageUnpacker in, ClusterService cluster) {
        int size = in.unpackInt();
        if (size < 1) {
            throw new IllegalArgumentException("nodes must not be empty.");
        }
        HashSet<String> nodeNames = new HashSet<String>(size);
        HashSet<InternalClusterNode> nodes = new HashSet<InternalClusterNode>(size);
        for (int i = 0; i < size; ++i) {
            String nodeName = in.unpackString();
            nodeNames.add(nodeName);
            InternalClusterNode node = cluster.topologyService().getByConsistentId(nodeName);
            if (node == null) continue;
            nodes.add(node);
        }
        if (nodes.isEmpty()) {
            throw new NodeNotFoundException(nodeNames);
        }
        return nodes;
    }

    static CompletableFuture<ComputeJobDataHolder> sendResultAndState(CompletableFuture<JobExecution<ComputeJobDataHolder>> executionFut, NotificationSender notificationSender) {
        return ((CompletableFuture)executionFut.handle((execution, throwable) -> {
            if (throwable != null) {
                notificationSender.sendNotification(null, (Throwable)throwable, 0L);
                return CompletableFuture.failedFuture(throwable);
            }
            return execution.resultAsync().whenComplete((val, err) -> execution.stateAsync().whenComplete((state, errState) -> {
                try {
                    notificationSender.sendNotification(w -> {
                        Marshaller marshaller = ClientComputeExecuteRequest.extractMarshaller(execution);
                        ClientComputeJobPacker.packJobResult(val, marshaller, w);
                        ClientComputeGetStateRequest.packJobState(w, state);
                    }, (Throwable)err, ClientComputeExecuteRequest.hybridTimestamp(val));
                }
                catch (Throwable e) {
                    LOG.error("Failed to send job result notification: " + e.getMessage(), e);
                }
            }));
        })).thenCompose(Function.identity());
    }

    static void packSubmitResult(ClientMessagePacker out, UUID jobId, ClusterNode node) {
        out.packUuid(jobId);
        ClientClusterGetNodesRequest.packClusterNode(node, out);
    }

    private static long hybridTimestamp(ComputeJobDataHolder holder) {
        if (holder == null) {
            return 0L;
        }
        Long observableTimestamp = holder.observableTimestamp();
        return observableTimestamp == null ? 0L : observableTimestamp;
    }

    @Nullable
    private static <T> Marshaller<T, byte[]> extractMarshaller(JobExecution<ComputeJobDataHolder> e) {
        if (e instanceof MarshallerProvider) {
            return ((MarshallerProvider)((Object)e)).resultMarshaller();
        }
        return null;
    }
}

