/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.concurrent.FutureContribution;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.testing.nio.AsyncRequester;
import org.apache.hc.core5.testing.nio.ClientSessionEndpoint;
import org.apache.hc.core5.testing.nio.InternalClientHttp1EventHandlerFactory;
import org.apache.hc.core5.util.Timeout;

public class Http1TestClient
extends AsyncRequester {
    private final SSLContext sslContext;
    private final SSLSessionInitializer sslSessionInitializer;
    private final SSLSessionVerifier sslSessionVerifier;

    public Http1TestClient(IOReactorConfig ioReactorConfig, SSLContext sslContext, SSLSessionInitializer sslSessionInitializer, SSLSessionVerifier sslSessionVerifier) throws IOException {
        super(ioReactorConfig);
        this.sslContext = sslContext;
        this.sslSessionInitializer = sslSessionInitializer;
        this.sslSessionVerifier = sslSessionVerifier;
    }

    public Http1TestClient() throws IOException {
        this(IOReactorConfig.DEFAULT, null, null, null);
    }

    public void start(HttpProcessor httpProcessor, Http1Config http1Config) throws IOException {
        this.execute(new InternalClientHttp1EventHandlerFactory(httpProcessor, http1Config, CharCodingConfig.DEFAULT, (ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE, this.sslContext, this.sslSessionInitializer, this.sslSessionVerifier));
    }

    public void start(Http1Config http1Config) throws IOException {
        this.start(HttpProcessors.client(), http1Config);
    }

    public void start() throws IOException {
        this.start(Http1Config.DEFAULT);
    }

    public Future<ClientSessionEndpoint> connect(HttpHost host, Timeout timeout, FutureCallback<ClientSessionEndpoint> callback) {
        final BasicFuture future = new BasicFuture(callback);
        this.requestSession(host, timeout, (FutureCallback<IOSession>)new FutureContribution<IOSession>(future){

            public void completed(IOSession session) {
                future.completed((Object)new ClientSessionEndpoint(session));
            }
        });
        return future;
    }

    public Future<ClientSessionEndpoint> connect(HttpHost host, Timeout timeout) {
        return this.connect(host, timeout, null);
    }

    public Future<ClientSessionEndpoint> connect(String hostname, int port, Timeout timeout) {
        return this.connect(new HttpHost(hostname, port), timeout, null);
    }
}

