/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import org.apache.felix.inventory.Format;
import org.apache.felix.webconsole.internal.AbstractConfigurationPrinter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;

public final class PermissionsConfigurationPrinter
extends AbstractConfigurationPrinter {
    private static final String TITLE = "Permissions";
    private static final String PERMISSION_ADMIN_NAME = "org.osgi.service.permissionadmin.PermissionAdmin";
    private static final String CONDITIONAL_PERMISSION_ADMIN_NAME = "org.osgi.service.condpermadmin.ConditionalPermissionAdmin";

    @Override
    protected final String getTitle() {
        return TITLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void print(PrintWriter pw, Format format, boolean isZip) {
        block16: {
            BundleContext bc = this.getBundleContext();
            ServiceReference paRef = bc.getServiceReference(PERMISSION_ADMIN_NAME);
            ServiceReference cpaRef = bc.getServiceReference(CONDITIONAL_PERMISSION_ADMIN_NAME);
            Object paSvc = paRef != null ? bc.getService(paRef) : null;
            Object cpaSvc = cpaRef != null ? bc.getService(cpaRef) : null;
            try {
                pw.print("Status: Permission Admin ");
                if (null == paSvc) {
                    pw.print("not ");
                }
                pw.print("available, Conditional Permission Admin ");
                if (null == cpaSvc) {
                    pw.print("not ");
                }
                pw.println("available.");
                if (paSvc != null) {
                    PermissionAdmin pa = (PermissionAdmin)paSvc;
                    pw.println();
                    pw.println("Permission Admin");
                    pw.println("  Default Permissions:");
                    PermissionsConfigurationPrinter.print(pa.getDefaultPermissions(), pw);
                    String[] locations = pa.getLocations();
                    for (int i = 0; locations != null && i < locations.length; ++i) {
                        pw.print("  Location: ");
                        pw.println(locations[i]);
                        PermissionsConfigurationPrinter.print(pa.getPermissions(locations[i]), pw);
                    }
                }
                if (cpaSvc == null) break block16;
                ConditionalPermissionAdmin cpa = (ConditionalPermissionAdmin)cpaSvc;
                pw.println();
                pw.println("Conditional Permission Admin");
                Method getAccessDecision = null;
                try {
                    getAccessDecision = ConditionalPermissionInfo.class.getMethod("getAccessDecision", null);
                }
                catch (Throwable i) {
                    // empty catch block
                }
                boolean hasPermissions = false;
                Enumeration e = cpa.getConditionalPermissionInfos();
                while (e.hasMoreElements()) {
                    hasPermissions = true;
                    ConditionalPermissionInfo info = (ConditionalPermissionInfo)e.nextElement();
                    pw.print("  ");
                    pw.print(info.getName());
                    if (getAccessDecision != null) {
                        try {
                            Object ad = getAccessDecision.invoke((Object)info, (Object[])null);
                            pw.print(" (");
                            pw.print(ad);
                            pw.print(")");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    pw.println();
                    pw.println("  Conditions:");
                    PermissionsConfigurationPrinter.print(info.getConditionInfos(), pw);
                    pw.println("  Permissions:");
                    PermissionsConfigurationPrinter.print(info.getPermissionInfos(), pw);
                }
                if (!hasPermissions) {
                    pw.println("  n/a");
                }
            }
            finally {
                if (paRef != null) {
                    bc.ungetService(paRef);
                }
                if (cpaRef != null) {
                    bc.ungetService(cpaRef);
                }
            }
        }
    }

    private static final void print(PermissionInfo[] infos, PrintWriter pw) {
        if (infos == null || infos.length == 0) {
            pw.println("    n/a");
        } else {
            int len = infos.length;
            for (int i = 0; i < len; ++i) {
                pw.print("    ");
                pw.println(infos[i].getEncoded());
            }
        }
        pw.println();
    }

    private static final void print(ConditionInfo[] infos, PrintWriter pw) {
        if (infos == null || infos.length == 0) {
            pw.println("    empty conditions set");
        } else {
            int len = infos.length;
            for (int i = 0; i < len; ++i) {
                pw.print("    ");
                pw.println(infos[i].getEncoded());
            }
        }
        pw.println();
    }
}

