/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.dispatch;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestAttributeEvent;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.dispatch.RequestInfo;
import org.apache.felix.http.base.internal.handler.HttpSessionWrapper;
import org.apache.felix.http.base.internal.util.UriUtils;
import org.osgi.service.useradmin.Authorization;

class ServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final List<String> FORWARD_ATTRIBUTES = Arrays.asList("jakarta.servlet.forward.context_path", "jakarta.servlet.forward.mapping", "jakarta.servlet.forward.path_info", "jakarta.servlet.forward.query_string", "jakarta.servlet.forward.request_uri", "jakarta.servlet.forward.servlet_path");
    private static final List<String> INCLUDE_ATTRIBUTES = Arrays.asList("jakarta.servlet.include.context_path", "jakarta.servlet.include.mapping", "jakarta.servlet.include.path_info", "jakarta.servlet.include.query_string", "jakarta.servlet.include.request_uri", "jakarta.servlet.include.servlet_path");
    private final DispatcherType type;
    private final RequestInfo requestInfo;
    private final ExtServletContext servletContext;
    private final boolean asyncSupported;

    public ServletRequestWrapper(HttpServletRequest req, ExtServletContext servletContext, RequestInfo requestInfo, DispatcherType type, boolean asyncSupported) {
        super(req);
        this.asyncSupported = asyncSupported;
        this.servletContext = servletContext;
        this.requestInfo = requestInfo;
        this.type = type;
    }

    public Object getAttribute(String name) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        if (this.isInclusionDispatcher() && !this.requestInfo.nameMatch) {
            if ("jakarta.servlet.include.request_uri".equals(name)) {
                return this.requestInfo.requestURI;
            }
            if ("jakarta.servlet.include.context_path".equals(name)) {
                return request.getContextPath();
            }
            if ("jakarta.servlet.include.servlet_path".equals(name)) {
                return this.requestInfo.servletPath;
            }
            if ("jakarta.servlet.include.path_info".equals(name)) {
                return this.requestInfo.pathInfo;
            }
            if ("jakarta.servlet.include.query_string".equals(name)) {
                return this.requestInfo.queryString;
            }
            if ("jakarta.servlet.include.mapping".equals(name)) {
                return this.requestInfo;
            }
            if (FORWARD_ATTRIBUTES.contains(name)) {
                return super.getAttribute(name);
            }
        } else if (this.isForwardingDispatcher() && !this.requestInfo.nameMatch) {
            if ("jakarta.servlet.forward.request_uri".equals(name)) {
                return super.getRequestURI();
            }
            if ("jakarta.servlet.forward.context_path".equals(name)) {
                return request.getContextPath();
            }
            if ("jakarta.servlet.forward.servlet_path".equals(name)) {
                return super.getServletPath();
            }
            if ("jakarta.servlet.forward.path_info".equals(name)) {
                return super.getPathInfo();
            }
            if ("jakarta.servlet.forward.query_string".equals(name)) {
                return super.getQueryString();
            }
            if ("jakarta.servlet.forward.mapping".equals(name)) {
                return super.getHttpServletMapping();
            }
        }
        if (INCLUDE_ATTRIBUTES.contains(name) || FORWARD_ATTRIBUTES.contains(name)) {
            return null;
        }
        return super.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (this.isForwardingDispatcher() || this.isInclusionDispatcher()) {
            HashSet allNames = new HashSet(Collections.list(super.getAttributeNames()));
            if (this.isForwardingDispatcher()) {
                allNames.addAll(FORWARD_ATTRIBUTES);
            } else {
                allNames.addAll(INCLUDE_ATTRIBUTES);
            }
            return Collections.enumeration(allNames);
        }
        return super.getAttributeNames();
    }

    public String getAuthType() {
        String authType = (String)this.getAttribute("org.osgi.service.http.authentication.type");
        if (authType == null) {
            authType = super.getAuthType();
        }
        return authType;
    }

    public String getContextPath() {
        return this.getServletContext().getContextPath();
    }

    public DispatcherType getDispatcherType() {
        return this.type == null ? super.getDispatcherType() : this.type;
    }

    public String getPathInfo() {
        if (this.isInclusionDispatcher()) {
            return super.getPathInfo();
        }
        return this.requestInfo.pathInfo;
    }

    public String getPathTranslated() {
        String info = this.getPathInfo();
        return null == info ? null : this.getServletContext().getRealPath(info);
    }

    public String getRemoteUser() {
        String remoteUser = (String)this.getAttribute("org.osgi.service.http.authentication.remote.user");
        if (remoteUser != null) {
            return remoteUser;
        }
        return super.getRemoteUser();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        boolean relPath;
        if (path == null) {
            return null;
        }
        boolean bl = relPath = !path.startsWith("/") && !"".equals(path);
        if (relPath) {
            path = UriUtils.concat(this.getServletPath(), path);
        }
        return this.servletContext.getRequestDispatcher(path);
    }

    public String getRequestURI() {
        if (this.isInclusionDispatcher()) {
            return super.getRequestURI();
        }
        return this.requestInfo.requestURI;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getServletPath() {
        if (this.isInclusionDispatcher()) {
            return super.getServletPath();
        }
        return this.requestInfo.servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = super.getSession(create);
        if (session == null) {
            return null;
        }
        if (!create && !HttpSessionWrapper.hasSession(this.servletContext.getServletContextName(), session)) {
            return null;
        }
        return new HttpSessionWrapper(session, this.servletContext, this.servletContext.getConfig(), false);
    }

    public boolean isUserInRole(String role) {
        Object authorization = this.getAttribute("org.osgi.service.useradmin.authorization");
        if (authorization instanceof Authorization) {
            return ((Authorization)authorization).hasRole(role);
        }
        return super.isUserInRole(role);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        }
        Object oldValue = this.getAttribute(name);
        super.setAttribute(name, value);
        if (this.servletContext.getServletRequestAttributeListener() != null) {
            if (oldValue == null) {
                this.servletContext.getServletRequestAttributeListener().attributeAdded(new ServletRequestAttributeEvent((ServletContext)this.servletContext, (ServletRequest)this, name, value));
            } else {
                this.servletContext.getServletRequestAttributeListener().attributeReplaced(new ServletRequestAttributeEvent((ServletContext)this.servletContext, (ServletRequest)this, name, oldValue));
            }
        }
    }

    public void removeAttribute(String name) {
        Object oldValue = this.getAttribute(name);
        if (oldValue != null) {
            super.removeAttribute(name);
            if (this.servletContext.getServletRequestAttributeListener() != null) {
                this.servletContext.getServletRequestAttributeListener().attributeRemoved(new ServletRequestAttributeEvent((ServletContext)this.servletContext, (ServletRequest)this, name, oldValue));
            }
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "->" + String.valueOf(super.getRequest());
    }

    private boolean isForwardingDispatcher() {
        return DispatcherType.FORWARD == this.type;
    }

    private boolean isInclusionDispatcher() {
        return DispatcherType.INCLUDE == this.type;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        if (!this.asyncSupported) {
            throw new IllegalStateException();
        }
        return super.startAsync();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (!this.asyncSupported) {
            throw new IllegalStateException();
        }
        return super.startAsync(servletRequest, servletResponse);
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        throw new ServletException("No Multipart-Support available");
    }

    public Part getPart(String name) throws IOException, ServletException {
        throw new ServletException("No Multipart-Support available");
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return super.getParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        Map<String, String[]> params = this.getParameterMap();
        return Collections.enumeration(params.keySet());
    }

    public String[] getParameterValues(String name) {
        Map<String, String[]> params = this.getParameterMap();
        return params.get(name);
    }

    public HttpServletMapping getHttpServletMapping() {
        return this.requestInfo;
    }
}

