/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.MemorySegmentRequest;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketchR;
import org.apache.datasketches.theta.HeapAlphaSketch;
import org.apache.datasketches.theta.HeapQuickSelectSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketchBuilder;
import org.apache.datasketches.theta.UpdateReturnState;

public abstract class UpdatableThetaSketch
extends ThetaSketch {
    private final long seed_;

    UpdatableThetaSketch(long seed) {
        this.seed_ = seed;
    }

    public static UpdatableThetaSketch wrap(MemorySegment srcWSeg) {
        return UpdatableThetaSketch.wrap(srcWSeg, null, 9001L);
    }

    public static UpdatableThetaSketch wrap(MemorySegment srcWSeg, MemorySegmentRequest mSegReq, long expectedSeed) {
        Objects.requireNonNull(srcWSeg, "Source MemorySegment must not be null");
        int preLongs = PreambleUtil.checkSegPreambleCap(srcWSeg) & 0x3F;
        int serVer = PreambleUtil.extractSerVer(srcWSeg);
        int familyID = PreambleUtil.extractFamilyID(srcWSeg);
        if (familyID != Family.QUICKSELECT.getID()) {
            Family family = Family.idToFamily(familyID);
            throw new SketchesArgumentException("A " + String.valueOf((Object)family) + " sketch cannot be wrapped as an UpdatableThetaSketch.");
        }
        if (serVer == 3 && preLongs == 3) {
            return DirectQuickSelectSketch.writableWrap(srcWSeg, mSegReq, expectedSeed);
        }
        throw new SketchesArgumentException("Corrupted: An UpdatableThetaSketch image must have SerVer = 3 and preLongs = 3");
    }

    public static UpdatableThetaSketch heapify(MemorySegment srcSeg) {
        return UpdatableThetaSketch.heapify(srcSeg, 9001L);
    }

    public static UpdatableThetaSketch heapify(MemorySegment srcSeg, long expectedSeed) {
        Objects.requireNonNull(srcSeg, "Source MemorySegment must not be null");
        PreambleUtil.checkSegPreambleCap(srcSeg);
        int familyID = PreambleUtil.extractFamilyID(srcSeg);
        if (familyID == Family.ALPHA.getID()) {
            return HeapAlphaSketch.heapifyInstance(srcSeg, expectedSeed);
        }
        return HeapQuickSelectSketch.heapifyInstance(srcSeg, expectedSeed);
    }

    @Override
    public CompactThetaSketch compact(boolean dstOrdered, MemorySegment dstWSeg) {
        return CompactOperations.componentsToCompact(this.getThetaLong(), this.getRetainedEntries(true), this.getSeedHash(), this.isEmpty(), false, false, dstOrdered, dstWSeg, this.getCache());
    }

    @Override
    public int getCompactBytes() {
        int preLongs = this.getCompactPreambleLongs();
        int dataLongs = this.getRetainedEntries(true);
        return preLongs + dataLongs << 3;
    }

    @Override
    int getCurrentDataLongs() {
        return 1 << this.getLgArrLongs();
    }

    @Override
    public boolean hasMemorySegment() {
        DirectQuickSelectSketchR dqssr;
        UpdatableThetaSketch updatableThetaSketch = this;
        return updatableThetaSketch instanceof DirectQuickSelectSketchR && (dqssr = (DirectQuickSelectSketchR)updatableThetaSketch).hasMemorySegment();
    }

    @Override
    public boolean isCompact() {
        return false;
    }

    @Override
    public boolean isOffHeap() {
        DirectQuickSelectSketchR dqssr;
        UpdatableThetaSketch updatableThetaSketch = this;
        return updatableThetaSketch instanceof DirectQuickSelectSketchR && (dqssr = (DirectQuickSelectSketchR)updatableThetaSketch).isOffHeap();
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        DirectQuickSelectSketchR dqssr;
        UpdatableThetaSketch updatableThetaSketch = this;
        return updatableThetaSketch instanceof DirectQuickSelectSketchR && (dqssr = (DirectQuickSelectSketchR)updatableThetaSketch).isSameResource(that);
    }

    public static final UpdatableThetaSketchBuilder builder() {
        return new UpdatableThetaSketchBuilder();
    }

    public abstract ResizeFactor getResizeFactor();

    abstract float getP();

    public long getSeed() {
        return this.seed_;
    }

    public abstract void reset();

    public abstract UpdatableThetaSketch rebuild();

    public UpdateReturnState update(long datum) {
        return this.hashUpdate(MurmurHash3.hash(datum, this.seed_)[0] >>> 1);
    }

    public UpdateReturnState update(double datum) {
        double d = datum == 0.0 ? 0.0 : datum;
        long data = Double.doubleToLongBits(d);
        return this.hashUpdate(MurmurHash3.hash(data, this.seed_)[0] >>> 1);
    }

    public UpdateReturnState update(String datum) {
        if (datum == null || datum.isEmpty()) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        byte[] data = datum.getBytes(StandardCharsets.UTF_8);
        return this.hashUpdate(MurmurHash3.hash(data, this.seed_)[0] >>> 1);
    }

    public UpdateReturnState update(byte[] data) {
        if (data == null || data.length == 0) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        return this.hashUpdate(MurmurHash3.hash(data, this.seed_)[0] >>> 1);
    }

    public UpdateReturnState update(ByteBuffer buffer) {
        if (buffer == null || !buffer.hasRemaining()) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        return this.hashUpdate(MurmurHash3.hash(buffer, this.seed_)[0] >>> 1);
    }

    public UpdateReturnState update(char[] data) {
        if (data == null || data.length == 0) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        return this.hashUpdate(MurmurHash3.hash(data, this.seed_)[0] >>> 1);
    }

    public UpdateReturnState update(int[] data) {
        if (data == null || data.length == 0) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        return this.hashUpdate(MurmurHash3.hash(data, this.seed_)[0] >>> 1);
    }

    public UpdateReturnState update(long[] data) {
        if (data == null || data.length == 0) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        return this.hashUpdate(MurmurHash3.hash(data, this.seed_)[0] >>> 1);
    }

    abstract UpdateReturnState hashUpdate(long var1);

    abstract int getLgArrLongs();

    public abstract int getLgNomLongs();

    abstract boolean isDirty();

    abstract boolean isOutOfSpace(int var1);

    static void checkUnionAndQuickSelectFamily(MemorySegment seg, int preambleLongs, int lgNomLongs) {
        int familyID = PreambleUtil.extractFamilyID(seg);
        if (familyID == Family.UNION.getID()) {
            if (preambleLongs != Family.UNION.getMinPreLongs()) {
                throw new SketchesArgumentException("Possible corruption: Invalid PreambleLongs value for UNION: " + preambleLongs);
            }
        } else if (familyID == Family.QUICKSELECT.getID()) {
            if (preambleLongs != Family.QUICKSELECT.getMinPreLongs()) {
                throw new SketchesArgumentException("Possible corruption: Invalid PreambleLongs value for QUICKSELECT: " + preambleLongs);
            }
        } else {
            Family family = Family.idToFamily(familyID);
            throw new SketchesArgumentException("Possible corruption: Invalid Family: " + family.toString());
        }
        if (lgNomLongs < 4) {
            throw new SketchesArgumentException("Possible corruption: Current MemorySegment lgNomLongs < min required size: " + lgNomLongs + " < 4");
        }
    }

    static void checkSegIntegrity(MemorySegment srcSeg, long expectedSeed, int preambleLongs, int lgNomLongs, int lgArrLongs) {
        int serVer = PreambleUtil.extractSerVer(srcSeg);
        if (serVer != 3) {
            throw new SketchesArgumentException("Possible corruption: Invalid Serialization Version: " + serVer);
        }
        int flags = PreambleUtil.extractFlags(srcSeg);
        int badFlagsMask = 26;
        if ((flags & 0x1A) > 0) {
            throw new SketchesArgumentException("Possible corruption: Input srcSeg cannot be: compact, ordered, nor read-only");
        }
        short seedHash = PreambleUtil.checkSegmentSeedHash(srcSeg, expectedSeed);
        Util.checkSeedHashes(seedHash, Util.computeSeedHash(expectedSeed));
        long curCapBytes = srcSeg.byteSize();
        int minReqBytes = PreambleUtil.getUpdatableSegBytes(lgArrLongs, preambleLongs);
        if (curCapBytes < (long)minReqBytes) {
            throw new SketchesArgumentException("Possible corruption: Current MemorySegment size < min required size: " + curCapBytes + " < " + minReqBytes);
        }
        float p = PreambleUtil.extractP(srcSeg);
        long thetaLong = PreambleUtil.extractThetaLong(srcSeg);
        double theta = (double)thetaLong / 9.223372036854776E18;
        if (lgArrLongs <= lgNomLongs && theta < (double)p) {
            throw new SketchesArgumentException("Possible corruption: Theta cannot be < p and lgArrLongs <= lgNomLongs. " + lgArrLongs + " <= " + lgNomLongs + ", Theta: " + theta + ", p: " + p);
        }
    }

    static boolean isResizeFactorIncorrect(MemorySegment srcSeg, int lgNomLongs, int lgArrLongs) {
        int lgT = lgNomLongs + 1;
        int lgA = lgArrLongs;
        int lgR = PreambleUtil.extractLgResizeFactor(srcSeg);
        if (lgR == 0) {
            return lgA != lgT;
        }
        return (lgT - lgA) % lgR != 0;
    }
}

