/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.math.BigInteger;
import java.nio.ByteBuffer;

final class UInt96 {
    private static final long MASK32 = 0xFFFFFFFFL;
    private int c;
    private long ab;

    private UInt96() {
    }

    private UInt96(long x) {
        this.c = (int)x;
        this.ab = (int)(x >>> 32);
    }

    UInt96(long hi, int lo) {
        this.c = lo;
        this.ab = hi;
    }

    static UInt96 create() {
        return new UInt96();
    }

    static UInt96 of(long x) {
        return new UInt96(x);
    }

    void addPositive(long x) {
        long s = x + ((long)this.c & 0xFFFFFFFFL);
        this.c = (int)s;
        this.ab += s >>> 32;
    }

    void add(UInt96 x) {
        int cc = x.c;
        long aabb = x.ab;
        long s = ((long)cc & 0xFFFFFFFFL) + ((long)this.c & 0xFFFFFFFFL);
        this.c = (int)s;
        this.ab += (s >>> 32) + aabb;
    }

    BigInteger toBigInteger() {
        if (this.ab != 0L) {
            ByteBuffer bb = ByteBuffer.allocate(12).putLong(this.ab).putInt(this.c);
            return new BigInteger(1, bb.array());
        }
        return BigInteger.valueOf((long)this.c & 0xFFFFFFFFL);
    }

    int lo32() {
        return this.c;
    }

    long hi64() {
        return this.ab;
    }
}

