/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Store and retrieve Java objects from databases using Java Persistence API
 * (JPA).
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface JpaEndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the JPA component.
     */
    public interface JpaEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedJpaEndpointConsumerBuilder advanced() {
            return (AdvancedJpaEndpointConsumerBuilder) this;
        }
        /**
         * The EntityManagerFactory to use.
         * 
         * The option is a:
         * <code>jakarta.persistence.EntityManagerFactory</code> type.
         * 
         * Group: common
         * 
         * @param entityManagerFactory the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder entityManagerFactory(jakarta.persistence.EntityManagerFactory entityManagerFactory) {
            doSetProperty("entityManagerFactory", entityManagerFactory);
            return this;
        }
        /**
         * The EntityManagerFactory to use.
         * 
         * The option will be converted to a
         * <code>jakarta.persistence.EntityManagerFactory</code> type.
         * 
         * Group: common
         * 
         * @param entityManagerFactory the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder entityManagerFactory(String entityManagerFactory) {
            doSetProperty("entityManagerFactory", entityManagerFactory);
            return this;
        }
        /**
         * The camel-jpa component will join transaction by default. You can use
         * this option to turn this off, for example, if you use LOCAL_RESOURCE
         * and join transaction doesn't work with your JPA provider. This option
         * can also be set globally on the JpaComponent, instead of having to
         * set it on all endpoints.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param joinTransaction the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder joinTransaction(boolean joinTransaction) {
            doSetProperty("joinTransaction", joinTransaction);
            return this;
        }
        /**
         * The camel-jpa component will join transaction by default. You can use
         * this option to turn this off, for example, if you use LOCAL_RESOURCE
         * and join transaction doesn't work with your JPA provider. This option
         * can also be set globally on the JpaComponent, instead of having to
         * set it on all endpoints.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param joinTransaction the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder joinTransaction(String joinTransaction) {
            doSetProperty("joinTransaction", joinTransaction);
            return this;
        }
        /**
         * Set the maximum number of results to retrieve on the Query.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param maximumResults the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder maximumResults(int maximumResults) {
            doSetProperty("maximumResults", maximumResults);
            return this;
        }
        /**
         * Set the maximum number of results to retrieve on the Query.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param maximumResults the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder maximumResults(String maximumResults) {
            doSetProperty("maximumResults", maximumResults);
            return this;
        }
        /**
         * To use a named query.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param namedQuery the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder namedQuery(String namedQuery) {
            doSetProperty("namedQuery", namedQuery);
            return this;
        }
        /**
         * To use a custom native query. You may want to use the option
         * resultClass also when using native queries.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param nativeQuery the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder nativeQuery(String nativeQuery) {
            doSetProperty("nativeQuery", nativeQuery);
            return this;
        }
        /**
         * The JPA persistence unit used by default.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Default: camel
         * Group: common
         * 
         * @param persistenceUnit the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder persistenceUnit(String persistenceUnit) {
            doSetProperty("persistenceUnit", persistenceUnit);
            return this;
        }
        /**
         * To use a custom query.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param query the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder query(String query) {
            doSetProperty("query", query);
            return this;
        }
        /**
         * Defines the type of the returned payload (we will call
         * entityManager.createNativeQuery(nativeQuery, resultClass) instead of
         * entityManager.createNativeQuery(nativeQuery)). Without this option,
         * we will return an object array. Only has an effect when using in
         * conjunction with a native query when consuming data.
         * 
         * The option is a: <code>java.lang.Class&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         * 
         * @param resultClass the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder resultClass(Class<java.lang.Object> resultClass) {
            doSetProperty("resultClass", resultClass);
            return this;
        }
        /**
         * Defines the type of the returned payload (we will call
         * entityManager.createNativeQuery(nativeQuery, resultClass) instead of
         * entityManager.createNativeQuery(nativeQuery)). Without this option,
         * we will return an object array. Only has an effect when using in
         * conjunction with a native query when consuming data.
         * 
         * The option will be converted to a
         * <code>java.lang.Class&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         * 
         * @param resultClass the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder resultClass(String resultClass) {
            doSetProperty("resultClass", resultClass);
            return this;
        }
        /**
         * If true, the entity is deleted after it is consumed; if false, the
         * entity is not deleted.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param consumeDelete the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder consumeDelete(boolean consumeDelete) {
            doSetProperty("consumeDelete", consumeDelete);
            return this;
        }
        /**
         * If true, the entity is deleted after it is consumed; if false, the
         * entity is not deleted.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param consumeDelete the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder consumeDelete(String consumeDelete) {
            doSetProperty("consumeDelete", consumeDelete);
            return this;
        }
        /**
         * Specifies whether to set an exclusive lock on each entity bean while
         * processing the results from polling.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param consumeLockEntity the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder consumeLockEntity(boolean consumeLockEntity) {
            doSetProperty("consumeLockEntity", consumeLockEntity);
            return this;
        }
        /**
         * Specifies whether to set an exclusive lock on each entity bean while
         * processing the results from polling.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param consumeLockEntity the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder consumeLockEntity(String consumeLockEntity) {
            doSetProperty("consumeLockEntity", consumeLockEntity);
            return this;
        }
        /**
         * To use a custom DeleteHandler to delete the row after the consumer is
         * done processing the exchange.
         * 
         * The option is a:
         * <code>org.apache.camel.component.jpa.DeleteHandler&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: consumer
         * 
         * @param deleteHandler the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder deleteHandler(org.apache.camel.component.jpa.DeleteHandler<java.lang.Object> deleteHandler) {
            doSetProperty("deleteHandler", deleteHandler);
            return this;
        }
        /**
         * To use a custom DeleteHandler to delete the row after the consumer is
         * done processing the exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.jpa.DeleteHandler&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: consumer
         * 
         * @param deleteHandler the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder deleteHandler(String deleteHandler) {
            doSetProperty("deleteHandler", deleteHandler);
            return this;
        }
        /**
         * To configure the lock mode on the consumer.
         * 
         * The option is a: <code>jakarta.persistence.LockModeType</code> type.
         * 
         * Default: PESSIMISTIC_WRITE
         * Group: consumer
         * 
         * @param lockModeType the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder lockModeType(jakarta.persistence.LockModeType lockModeType) {
            doSetProperty("lockModeType", lockModeType);
            return this;
        }
        /**
         * To configure the lock mode on the consumer.
         * 
         * The option will be converted to a
         * <code>jakarta.persistence.LockModeType</code> type.
         * 
         * Default: PESSIMISTIC_WRITE
         * Group: consumer
         * 
         * @param lockModeType the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder lockModeType(String lockModeType) {
            doSetProperty("lockModeType", lockModeType);
            return this;
        }
        /**
         * An integer value to define the maximum number of messages to gather
         * per poll. By default, no maximum is set. It can be used to avoid
         * polling many thousands of messages when starting up the server. Set a
         * value of 0 or negative to disable.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder maxMessagesPerPoll(int maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * An integer value to define the maximum number of messages to gather
         * per poll. By default, no maximum is set. It can be used to avoid
         * polling many thousands of messages when starting up the server. Set a
         * value of 0 or negative to disable.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder maxMessagesPerPoll(String maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * To use a custom Pre-DeleteHandler to delete the row after the
         * consumer has read the entity.
         * 
         * The option is a:
         * <code>org.apache.camel.component.jpa.DeleteHandler&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: consumer
         * 
         * @param preDeleteHandler the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder preDeleteHandler(org.apache.camel.component.jpa.DeleteHandler<java.lang.Object> preDeleteHandler) {
            doSetProperty("preDeleteHandler", preDeleteHandler);
            return this;
        }
        /**
         * To use a custom Pre-DeleteHandler to delete the row after the
         * consumer has read the entity.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.jpa.DeleteHandler&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: consumer
         * 
         * @param preDeleteHandler the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder preDeleteHandler(String preDeleteHandler) {
            doSetProperty("preDeleteHandler", preDeleteHandler);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder sendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder sendEmptyMessageWhenIdle(String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * To configure whether to use NOWAIT on lock and silently skip the
         * entity.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param skipLockedEntity the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder skipLockedEntity(boolean skipLockedEntity) {
            doSetProperty("skipLockedEntity", skipLockedEntity);
            return this;
        }
        /**
         * To configure whether to use NOWAIT on lock and silently skip the
         * entity.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param skipLockedEntity the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder skipLockedEntity(String skipLockedEntity) {
            doSetProperty("skipLockedEntity", skipLockedEntity);
            return this;
        }
        /**
         * Whether to run the consumer in transacted mode, by which all messages
         * will either commit or rollback, when the entire batch has been
         * processed. The default behavior (false) is to commit all the
         * previously successfully processed messages, and only roll back the
         * last failed message.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder transacted(boolean transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Whether to run the consumer in transacted mode, by which all messages
         * will either commit or rollback, when the entire batch has been
         * processed. The default behavior (false) is to commit all the
         * previously successfully processed messages, and only roll back the
         * last failed message.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder transacted(String transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder backoffErrorThreshold(int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder backoffErrorThreshold(String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder backoffIdleThreshold(int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder backoffIdleThreshold(String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder backoffMultiplier(int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder backoffMultiplier(String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder runLoggingLevel(org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder runLoggingLevel(String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder scheduledExecutorService(String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler. This is a multi-value
         * option with prefix: scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder schedulerProperties(String key, Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler. This is a multi-value
         * option with prefix: scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder startScheduler(boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default JpaEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the JPA component.
     */
    public interface AdvancedJpaEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default JpaEndpointConsumerBuilder basic() {
            return (JpaEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * This key/value mapping is used for building the query parameters. It
         * is expected to be of the generic type java.util.Map where the keys
         * are the named parameters of a given JPA query and the values are
         * their corresponding effective values you want to select for. When
         * it's used for producer, Simple expression can be used as a parameter
         * value. It allows you to retrieve parameter values from the message
         * body, header and etc. . This is a multi-value option with prefix:
         * parameters.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the parameters(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: consumer (advanced)
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedJpaEndpointConsumerBuilder parameters(String key, Object value) {
            doSetMultiValueProperty("parameters", "parameters." + key, value);
            return this;
        }
        /**
         * This key/value mapping is used for building the query parameters. It
         * is expected to be of the generic type java.util.Map where the keys
         * are the named parameters of a given JPA query and the values are
         * their corresponding effective values you want to select for. When
         * it's used for producer, Simple expression can be used as a parameter
         * value. It allows you to retrieve parameter values from the message
         * body, header and etc. . This is a multi-value option with prefix:
         * parameters.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the parameters(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: consumer (advanced)
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedJpaEndpointConsumerBuilder parameters(Map values) {
            doSetMultiValueProperties("parameters", "parameters.", values);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointConsumerBuilder pollStrategy(org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointConsumerBuilder pollStrategy(String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Additional properties for the entity manager to use. This is a
         * multi-value option with prefix: emf.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * entityManagerProperties(String, Object) method to add a value (call
         * the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedJpaEndpointConsumerBuilder entityManagerProperties(String key, Object value) {
            doSetMultiValueProperty("entityManagerProperties", "emf." + key, value);
            return this;
        }
        /**
         * Additional properties for the entity manager to use. This is a
         * multi-value option with prefix: emf.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * entityManagerProperties(String, Object) method to add a value (call
         * the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedJpaEndpointConsumerBuilder entityManagerProperties(Map values) {
            doSetMultiValueProperties("entityManagerProperties", "emf.", values);
            return this;
        }
        /**
         * Whether to use Spring's SharedEntityManager for the
         * consumer/producer. Note in most cases, joinTransaction should be set
         * to false as this is not an EXTENDED EntityManager.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param sharedEntityManager the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointConsumerBuilder sharedEntityManager(boolean sharedEntityManager) {
            doSetProperty("sharedEntityManager", sharedEntityManager);
            return this;
        }
        /**
         * Whether to use Spring's SharedEntityManager for the
         * consumer/producer. Note in most cases, joinTransaction should be set
         * to false as this is not an EXTENDED EntityManager.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param sharedEntityManager the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointConsumerBuilder sharedEntityManager(String sharedEntityManager) {
            doSetProperty("sharedEntityManager", sharedEntityManager);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the JPA component.
     */
    public interface JpaEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedJpaEndpointProducerBuilder advanced() {
            return (AdvancedJpaEndpointProducerBuilder) this;
        }

        /**
         * The EntityManagerFactory to use.
         * 
         * The option is a:
         * <code>jakarta.persistence.EntityManagerFactory</code> type.
         * 
         * Group: common
         * 
         * @param entityManagerFactory the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder entityManagerFactory(jakarta.persistence.EntityManagerFactory entityManagerFactory) {
            doSetProperty("entityManagerFactory", entityManagerFactory);
            return this;
        }
        /**
         * The EntityManagerFactory to use.
         * 
         * The option will be converted to a
         * <code>jakarta.persistence.EntityManagerFactory</code> type.
         * 
         * Group: common
         * 
         * @param entityManagerFactory the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder entityManagerFactory(String entityManagerFactory) {
            doSetProperty("entityManagerFactory", entityManagerFactory);
            return this;
        }
        /**
         * The camel-jpa component will join transaction by default. You can use
         * this option to turn this off, for example, if you use LOCAL_RESOURCE
         * and join transaction doesn't work with your JPA provider. This option
         * can also be set globally on the JpaComponent, instead of having to
         * set it on all endpoints.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param joinTransaction the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder joinTransaction(boolean joinTransaction) {
            doSetProperty("joinTransaction", joinTransaction);
            return this;
        }
        /**
         * The camel-jpa component will join transaction by default. You can use
         * this option to turn this off, for example, if you use LOCAL_RESOURCE
         * and join transaction doesn't work with your JPA provider. This option
         * can also be set globally on the JpaComponent, instead of having to
         * set it on all endpoints.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param joinTransaction the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder joinTransaction(String joinTransaction) {
            doSetProperty("joinTransaction", joinTransaction);
            return this;
        }
        /**
         * Set the maximum number of results to retrieve on the Query.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param maximumResults the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder maximumResults(int maximumResults) {
            doSetProperty("maximumResults", maximumResults);
            return this;
        }
        /**
         * Set the maximum number of results to retrieve on the Query.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param maximumResults the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder maximumResults(String maximumResults) {
            doSetProperty("maximumResults", maximumResults);
            return this;
        }
        /**
         * To use a named query.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param namedQuery the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder namedQuery(String namedQuery) {
            doSetProperty("namedQuery", namedQuery);
            return this;
        }
        /**
         * To use a custom native query. You may want to use the option
         * resultClass also when using native queries.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param nativeQuery the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder nativeQuery(String nativeQuery) {
            doSetProperty("nativeQuery", nativeQuery);
            return this;
        }
        /**
         * The JPA persistence unit used by default.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Default: camel
         * Group: common
         * 
         * @param persistenceUnit the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder persistenceUnit(String persistenceUnit) {
            doSetProperty("persistenceUnit", persistenceUnit);
            return this;
        }
        /**
         * To use a custom query.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param query the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder query(String query) {
            doSetProperty("query", query);
            return this;
        }
        /**
         * Defines the type of the returned payload (we will call
         * entityManager.createNativeQuery(nativeQuery, resultClass) instead of
         * entityManager.createNativeQuery(nativeQuery)). Without this option,
         * we will return an object array. Only has an effect when using in
         * conjunction with a native query when consuming data.
         * 
         * The option is a: <code>java.lang.Class&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         * 
         * @param resultClass the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder resultClass(Class<java.lang.Object> resultClass) {
            doSetProperty("resultClass", resultClass);
            return this;
        }
        /**
         * Defines the type of the returned payload (we will call
         * entityManager.createNativeQuery(nativeQuery, resultClass) instead of
         * entityManager.createNativeQuery(nativeQuery)). Without this option,
         * we will return an object array. Only has an effect when using in
         * conjunction with a native query when consuming data.
         * 
         * The option will be converted to a
         * <code>java.lang.Class&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         * 
         * @param resultClass the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder resultClass(String resultClass) {
            doSetProperty("resultClass", resultClass);
            return this;
        }
        /**
         * If enabled, then the producer will find a single entity by using the
         * message body as a key and entityType as the class type. This can be
         * used instead of a query to find a single entity.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param findEntity the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder findEntity(boolean findEntity) {
            doSetProperty("findEntity", findEntity);
            return this;
        }
        /**
         * If enabled, then the producer will find a single entity by using the
         * message body as a key and entityType as the class type. This can be
         * used instead of a query to find a single entity.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param findEntity the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder findEntity(String findEntity) {
            doSetProperty("findEntity", findEntity);
            return this;
        }
        /**
         * Set the position of the first result to retrieve.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: -1
         * Group: producer
         * 
         * @param firstResult the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder firstResult(int firstResult) {
            doSetProperty("firstResult", firstResult);
            return this;
        }
        /**
         * Set the position of the first result to retrieve.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: -1
         * Group: producer
         * 
         * @param firstResult the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder firstResult(String firstResult) {
            doSetProperty("firstResult", firstResult);
            return this;
        }
        /**
         * Flushes the EntityManager after the entity bean has been persisted.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param flushOnSend the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder flushOnSend(boolean flushOnSend) {
            doSetProperty("flushOnSend", flushOnSend);
            return this;
        }
        /**
         * Flushes the EntityManager after the entity bean has been persisted.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param flushOnSend the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder flushOnSend(String flushOnSend) {
            doSetProperty("flushOnSend", flushOnSend);
            return this;
        }
        /**
         * To put the query (or find) result in a header or property instead of
         * the body. If the value starts with the prefix property:, put the
         * result into the so named property, otherwise into the header.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param outputTarget the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder outputTarget(String outputTarget) {
            doSetProperty("outputTarget", outputTarget);
            return this;
        }
        /**
         * Indicates to use entityManager.remove(entity).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param remove the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder remove(boolean remove) {
            doSetProperty("remove", remove);
            return this;
        }
        /**
         * Indicates to use entityManager.remove(entity).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param remove the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder remove(String remove) {
            doSetProperty("remove", remove);
            return this;
        }
        /**
         * If enabled, a query or a find which would return no results or more
         * than one result, will throw an exception instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param singleResult the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder singleResult(boolean singleResult) {
            doSetProperty("singleResult", singleResult);
            return this;
        }
        /**
         * If enabled, a query or a find which would return no results or more
         * than one result, will throw an exception instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param singleResult the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder singleResult(String singleResult) {
            doSetProperty("singleResult", singleResult);
            return this;
        }
        /**
         * To configure whether to use executeUpdate() when producer executes a
         * query. When you use INSERT, UPDATE or a DELETE statement as a named
         * query, you need to specify this option to 'true'.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: producer
         * 
         * @param useExecuteUpdate the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder useExecuteUpdate(Boolean useExecuteUpdate) {
            doSetProperty("useExecuteUpdate", useExecuteUpdate);
            return this;
        }
        /**
         * To configure whether to use executeUpdate() when producer executes a
         * query. When you use INSERT, UPDATE or a DELETE statement as a named
         * query, you need to specify this option to 'true'.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: producer
         * 
         * @param useExecuteUpdate the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder useExecuteUpdate(String useExecuteUpdate) {
            doSetProperty("useExecuteUpdate", useExecuteUpdate);
            return this;
        }
        /**
         * Indicates to use entityManager.persist(entity) instead of
         * entityManager.merge(entity). Note: entityManager.persist(entity)
         * doesn't work for detached entities (where the EntityManager has to
         * execute an UPDATE instead of an INSERT query)!.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param usePersist the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder usePersist(boolean usePersist) {
            doSetProperty("usePersist", usePersist);
            return this;
        }
        /**
         * Indicates to use entityManager.persist(entity) instead of
         * entityManager.merge(entity). Note: entityManager.persist(entity)
         * doesn't work for detached entities (where the EntityManager has to
         * execute an UPDATE instead of an INSERT query)!.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param usePersist the value to set
         * @return the dsl builder
         */
        default JpaEndpointProducerBuilder usePersist(String usePersist) {
            doSetProperty("usePersist", usePersist);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the JPA component.
     */
    public interface AdvancedJpaEndpointProducerBuilder extends EndpointProducerBuilder {
        default JpaEndpointProducerBuilder basic() {
            return (JpaEndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * If set to true, then Camel will use the EntityManager from the header
         * JpaConstants.ENTITY_MANAGER instead of the configured entity manager
         * on the component/endpoint. This allows end users to control which
         * entity manager will be in use.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param usePassedInEntityManager the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointProducerBuilder usePassedInEntityManager(boolean usePassedInEntityManager) {
            doSetProperty("usePassedInEntityManager", usePassedInEntityManager);
            return this;
        }
        /**
         * If set to true, then Camel will use the EntityManager from the header
         * JpaConstants.ENTITY_MANAGER instead of the configured entity manager
         * on the component/endpoint. This allows end users to control which
         * entity manager will be in use.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param usePassedInEntityManager the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointProducerBuilder usePassedInEntityManager(String usePassedInEntityManager) {
            doSetProperty("usePassedInEntityManager", usePassedInEntityManager);
            return this;
        }
        /**
         * Additional properties for the entity manager to use. This is a
         * multi-value option with prefix: emf.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * entityManagerProperties(String, Object) method to add a value (call
         * the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedJpaEndpointProducerBuilder entityManagerProperties(String key, Object value) {
            doSetMultiValueProperty("entityManagerProperties", "emf." + key, value);
            return this;
        }
        /**
         * Additional properties for the entity manager to use. This is a
         * multi-value option with prefix: emf.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * entityManagerProperties(String, Object) method to add a value (call
         * the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedJpaEndpointProducerBuilder entityManagerProperties(Map values) {
            doSetMultiValueProperties("entityManagerProperties", "emf.", values);
            return this;
        }
        /**
         * Whether to use Spring's SharedEntityManager for the
         * consumer/producer. Note in most cases, joinTransaction should be set
         * to false as this is not an EXTENDED EntityManager.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param sharedEntityManager the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointProducerBuilder sharedEntityManager(boolean sharedEntityManager) {
            doSetProperty("sharedEntityManager", sharedEntityManager);
            return this;
        }
        /**
         * Whether to use Spring's SharedEntityManager for the
         * consumer/producer. Note in most cases, joinTransaction should be set
         * to false as this is not an EXTENDED EntityManager.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param sharedEntityManager the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointProducerBuilder sharedEntityManager(String sharedEntityManager) {
            doSetProperty("sharedEntityManager", sharedEntityManager);
            return this;
        }
    }

    /**
     * Builder for endpoint for the JPA component.
     */
    public interface JpaEndpointBuilder
            extends
                JpaEndpointConsumerBuilder,
                JpaEndpointProducerBuilder {
        default AdvancedJpaEndpointBuilder advanced() {
            return (AdvancedJpaEndpointBuilder) this;
        }

        /**
         * The EntityManagerFactory to use.
         * 
         * The option is a:
         * <code>jakarta.persistence.EntityManagerFactory</code> type.
         * 
         * Group: common
         * 
         * @param entityManagerFactory the value to set
         * @return the dsl builder
         */
        default JpaEndpointBuilder entityManagerFactory(jakarta.persistence.EntityManagerFactory entityManagerFactory) {
            doSetProperty("entityManagerFactory", entityManagerFactory);
            return this;
        }
        /**
         * The EntityManagerFactory to use.
         * 
         * The option will be converted to a
         * <code>jakarta.persistence.EntityManagerFactory</code> type.
         * 
         * Group: common
         * 
         * @param entityManagerFactory the value to set
         * @return the dsl builder
         */
        default JpaEndpointBuilder entityManagerFactory(String entityManagerFactory) {
            doSetProperty("entityManagerFactory", entityManagerFactory);
            return this;
        }
        /**
         * The camel-jpa component will join transaction by default. You can use
         * this option to turn this off, for example, if you use LOCAL_RESOURCE
         * and join transaction doesn't work with your JPA provider. This option
         * can also be set globally on the JpaComponent, instead of having to
         * set it on all endpoints.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param joinTransaction the value to set
         * @return the dsl builder
         */
        default JpaEndpointBuilder joinTransaction(boolean joinTransaction) {
            doSetProperty("joinTransaction", joinTransaction);
            return this;
        }
        /**
         * The camel-jpa component will join transaction by default. You can use
         * this option to turn this off, for example, if you use LOCAL_RESOURCE
         * and join transaction doesn't work with your JPA provider. This option
         * can also be set globally on the JpaComponent, instead of having to
         * set it on all endpoints.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param joinTransaction the value to set
         * @return the dsl builder
         */
        default JpaEndpointBuilder joinTransaction(String joinTransaction) {
            doSetProperty("joinTransaction", joinTransaction);
            return this;
        }
        /**
         * Set the maximum number of results to retrieve on the Query.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param maximumResults the value to set
         * @return the dsl builder
         */
        default JpaEndpointBuilder maximumResults(int maximumResults) {
            doSetProperty("maximumResults", maximumResults);
            return this;
        }
        /**
         * Set the maximum number of results to retrieve on the Query.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param maximumResults the value to set
         * @return the dsl builder
         */
        default JpaEndpointBuilder maximumResults(String maximumResults) {
            doSetProperty("maximumResults", maximumResults);
            return this;
        }
        /**
         * To use a named query.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param namedQuery the value to set
         * @return the dsl builder
         */
        default JpaEndpointBuilder namedQuery(String namedQuery) {
            doSetProperty("namedQuery", namedQuery);
            return this;
        }
        /**
         * To use a custom native query. You may want to use the option
         * resultClass also when using native queries.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param nativeQuery the value to set
         * @return the dsl builder
         */
        default JpaEndpointBuilder nativeQuery(String nativeQuery) {
            doSetProperty("nativeQuery", nativeQuery);
            return this;
        }
        /**
         * The JPA persistence unit used by default.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Default: camel
         * Group: common
         * 
         * @param persistenceUnit the value to set
         * @return the dsl builder
         */
        default JpaEndpointBuilder persistenceUnit(String persistenceUnit) {
            doSetProperty("persistenceUnit", persistenceUnit);
            return this;
        }
        /**
         * To use a custom query.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param query the value to set
         * @return the dsl builder
         */
        default JpaEndpointBuilder query(String query) {
            doSetProperty("query", query);
            return this;
        }
        /**
         * Defines the type of the returned payload (we will call
         * entityManager.createNativeQuery(nativeQuery, resultClass) instead of
         * entityManager.createNativeQuery(nativeQuery)). Without this option,
         * we will return an object array. Only has an effect when using in
         * conjunction with a native query when consuming data.
         * 
         * The option is a: <code>java.lang.Class&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         * 
         * @param resultClass the value to set
         * @return the dsl builder
         */
        default JpaEndpointBuilder resultClass(Class<java.lang.Object> resultClass) {
            doSetProperty("resultClass", resultClass);
            return this;
        }
        /**
         * Defines the type of the returned payload (we will call
         * entityManager.createNativeQuery(nativeQuery, resultClass) instead of
         * entityManager.createNativeQuery(nativeQuery)). Without this option,
         * we will return an object array. Only has an effect when using in
         * conjunction with a native query when consuming data.
         * 
         * The option will be converted to a
         * <code>java.lang.Class&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         * 
         * @param resultClass the value to set
         * @return the dsl builder
         */
        default JpaEndpointBuilder resultClass(String resultClass) {
            doSetProperty("resultClass", resultClass);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the JPA component.
     */
    public interface AdvancedJpaEndpointBuilder
            extends
                AdvancedJpaEndpointConsumerBuilder,
                AdvancedJpaEndpointProducerBuilder {
        default JpaEndpointBuilder basic() {
            return (JpaEndpointBuilder) this;
        }

        /**
         * Additional properties for the entity manager to use. This is a
         * multi-value option with prefix: emf.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * entityManagerProperties(String, Object) method to add a value (call
         * the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedJpaEndpointBuilder entityManagerProperties(String key, Object value) {
            doSetMultiValueProperty("entityManagerProperties", "emf." + key, value);
            return this;
        }
        /**
         * Additional properties for the entity manager to use. This is a
         * multi-value option with prefix: emf.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * entityManagerProperties(String, Object) method to add a value (call
         * the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedJpaEndpointBuilder entityManagerProperties(Map values) {
            doSetMultiValueProperties("entityManagerProperties", "emf.", values);
            return this;
        }
        /**
         * Whether to use Spring's SharedEntityManager for the
         * consumer/producer. Note in most cases, joinTransaction should be set
         * to false as this is not an EXTENDED EntityManager.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param sharedEntityManager the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointBuilder sharedEntityManager(boolean sharedEntityManager) {
            doSetProperty("sharedEntityManager", sharedEntityManager);
            return this;
        }
        /**
         * Whether to use Spring's SharedEntityManager for the
         * consumer/producer. Note in most cases, joinTransaction should be set
         * to false as this is not an EXTENDED EntityManager.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param sharedEntityManager the value to set
         * @return the dsl builder
         */
        default AdvancedJpaEndpointBuilder sharedEntityManager(String sharedEntityManager) {
            doSetProperty("sharedEntityManager", sharedEntityManager);
            return this;
        }
    }

    public interface JpaBuilders {
        /**
         * JPA (camel-jpa)
         * Store and retrieve Java objects from databases using Java Persistence
         * API (JPA).
         * 
         * Category: database
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-jpa
         * 
         * @return the dsl builder for the headers' name.
         */
        default JpaHeaderNameBuilder jpa() {
            return JpaHeaderNameBuilder.INSTANCE;
        }
        /**
         * JPA (camel-jpa)
         * Store and retrieve Java objects from databases using Java Persistence
         * API (JPA).
         * 
         * Category: database
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-jpa
         * 
         * Syntax: <code>jpa:entityType</code>
         * 
         * Path parameter: entityType (required)
         * Entity class name
         * 
         * @param path entityType
         * @return the dsl builder
         */
        default JpaEndpointBuilder jpa(String path) {
            return JpaEndpointBuilderFactory.endpointBuilder("jpa", path);
        }
        /**
         * JPA (camel-jpa)
         * Store and retrieve Java objects from databases using Java Persistence
         * API (JPA).
         * 
         * Category: database
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-jpa
         * 
         * Syntax: <code>jpa:entityType</code>
         * 
         * Path parameter: entityType (required)
         * Entity class name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path entityType
         * @return the dsl builder
         */
        default JpaEndpointBuilder jpa(String componentName, String path) {
            return JpaEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the JPA component.
     */
    public static class JpaHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final JpaHeaderNameBuilder INSTANCE = new JpaHeaderNameBuilder();

        /**
         * The JPA EntityManager object.
         * 
         * The option is a: {@code jakarta.persistence.EntityManager} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code EntityManager}.
         */
        public String entityManager() {
            return "CamelEntityManager";
        }
        /**
         * Alternative way for passing query parameters as an Exchange header.
         * 
         * The option is a: {@code Map<String, Object>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code JpaParameters}.
         */
        public String jpaParameters() {
            return "CamelJpaParameters";
        }
        /**
         * Defines the maximum number of results to retrieve on the query; takes
         * precedence over the value set on the endpoint, if any.
         * 
         * The option is a: {@code } type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code JpaMaximumResults}.
         */
        public String jpaMaximumResults() {
            return "CamelJpaMaximumResults";
        }
        /**
         * Defines the position of the first result to retrieve; takes
         * precedence over the value set on the endpoint, if any.
         * 
         * The option is a: {@code } type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code JpaFirstResult}.
         */
        public String jpaFirstResult() {
            return "CamelJpaFirstResult";
        }
    }
    static JpaEndpointBuilder endpointBuilder(String componentName, String path) {
        class JpaEndpointBuilderImpl extends AbstractEndpointBuilder implements JpaEndpointBuilder, AdvancedJpaEndpointBuilder {
            public JpaEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new JpaEndpointBuilderImpl(path);
    }
}