/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.util.ArrayList;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.DirectObject;
import org.jibx.binding.def.DirectProperty;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.IMapping;
import org.jibx.binding.def.ITypeBinding;
import org.jibx.binding.def.MappingDefinition;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.NamespaceDefinition;
import org.jibx.binding.def.PropertyDefinition;
import org.jibx.runtime.JiBXException;

public class PrecompiledConcreteMapping
implements IMapping {
    private final ClassFile m_class;
    private final String m_mappingName;
    private final NameDefinition m_name;
    private final IContainer m_container;
    private final String m_factoryName;
    private ClassFile m_marshaller;
    private ClassFile m_unmarshaller;

    public PrecompiledConcreteMapping(String mapname, String type, NameDefinition name, String marname, String umarname, IContainer parent, boolean xlated, String factname) throws JiBXException {
        this.m_class = ClassCache.requireClassFile(type);
        this.m_mappingName = mapname;
        parent.getBindingRoot().addMappingName(mapname);
        this.m_name = name;
        this.m_container = parent;
        this.m_factoryName = xlated ? factname : null;
        this.m_marshaller = marname == null ? null : ClassCache.requireClassFile(marname);
        this.m_unmarshaller = umarname == null ? null : ClassCache.requireClassFile(umarname);
    }

    public void linkMappings() throws JiBXException {
    }

    @Override
    public String getBoundType() {
        return this.m_class.getName();
    }

    @Override
    public String getReferenceType() {
        return this.m_mappingName;
    }

    @Override
    public IComponent getImplComponent() {
        return null;
    }

    @Override
    public ClassFile getMarshaller() {
        return this.m_marshaller;
    }

    @Override
    public ClassFile getUnmarshaller() {
        return this.m_unmarshaller;
    }

    @Override
    public NameDefinition getName() {
        return this.m_name;
    }

    @Override
    public void addNamespace(NamespaceDefinition ns) throws JiBXException {
        throw new IllegalArgumentException("Internal error - namespace cannot be added to precompiled mapping");
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isBase() {
        return false;
    }

    @Override
    public void addExtension(MappingDefinition mdef) throws JiBXException {
        throw new IllegalArgumentException("Internal error - extension cannot be added to precompiled mapping");
    }

    @Override
    public IComponent buildRef(IContainer parent, IContextObj objc, String type, PropertyDefinition prop) throws JiBXException {
        DirectObject dobj = new DirectObject(this.m_container, null, this.m_class, false, this.m_marshaller, this.m_unmarshaller, this.m_mappingName, null, this.m_factoryName);
        return new DirectProperty(prop, dobj);
    }

    @Override
    public ArrayList getNamespaces() {
        return null;
    }

    @Override
    public void generateCode(boolean force) throws JiBXException {
    }

    public NameDefinition getWrapperName() {
        return this.m_name;
    }

    @Override
    public ITypeBinding getBinding() {
        return null;
    }

    @Override
    public String getMappingName() {
        return this.m_mappingName;
    }

    @Override
    public String getTypeName() {
        return null;
    }

    @Override
    public void setLinkages() throws JiBXException {
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("precompiled mapping class " + this.m_class.getName());
        System.out.println(" ('" + this.getMappingName() + "')");
    }
}

