/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.builder.converter;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.jws.HandlerChain;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlList;
import javax.xml.ws.WebServiceRef;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.FieldDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.HandlerChainAnnot;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.ParameterDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.SoapBindingAnnot;
import org.apache.axis2.jaxws.description.builder.TMAnnotationComposite;
import org.apache.axis2.jaxws.description.builder.TMFAnnotationComposite;
import org.apache.axis2.jaxws.description.builder.WebServiceRefAnnot;

public class ConverterUtils {
    public static Annotation getAnnotation(final Class annotationClass, final AnnotatedElement element) {
        return (Annotation)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return element.getAnnotation(annotationClass);
            }
        });
    }

    public static <T extends Annotation> List<Annotation> getAnnotations(Class<T> annotationClass, final AnnotatedElement element) {
        ArrayList<Annotation> matches = new ArrayList<Annotation>();
        Annotation[] annotations = null;
        for (Annotation a : annotations = (Annotation[])AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return element.getAnnotations();
            }
        })) {
            if (!a.annotationType().isAnnotationPresent(annotationClass) && !annotationClass.isAssignableFrom(a.annotationType())) continue;
            matches.add(a);
        }
        return matches;
    }

    public static HandlerChainAnnot createHandlerChainAnnot(HandlerChain handlerChain) {
        HandlerChainAnnot hcAnnot = HandlerChainAnnot.createHandlerChainAnnotImpl();
        hcAnnot.setFile(handlerChain.file());
        hcAnnot.setName(handlerChain.name());
        return hcAnnot;
    }

    public static SoapBindingAnnot createSoapBindingAnnot(SOAPBinding soapBinding) {
        SoapBindingAnnot sbAnnot = SoapBindingAnnot.createSoapBindingAnnotImpl();
        sbAnnot.setParameterStyle(soapBinding.parameterStyle());
        sbAnnot.setStyle(soapBinding.style());
        sbAnnot.setUse(soapBinding.use());
        return sbAnnot;
    }

    public static WebServiceRefAnnot createWebServiceRefAnnot(WebServiceRef webServiceRef) {
        WebServiceRefAnnot wsrAnnot = WebServiceRefAnnot.createWebServiceRefAnnotImpl();
        wsrAnnot.setMappedName(webServiceRef.mappedName());
        wsrAnnot.setName(webServiceRef.name());
        wsrAnnot.setType(webServiceRef.type());
        wsrAnnot.setValue(webServiceRef.value());
        wsrAnnot.setWsdlLocation(webServiceRef.wsdlLocation());
        return wsrAnnot;
    }

    public static void attachHandlerChainAnnotation(TMFAnnotationComposite composite, AnnotatedElement annotatedElement) {
        HandlerChain handlerChain = (HandlerChain)ConverterUtils.getAnnotation(HandlerChain.class, annotatedElement);
        if (handlerChain != null) {
            HandlerChainAnnot hcAnnot = ConverterUtils.createHandlerChainAnnot(handlerChain);
            composite.setHandlerChainAnnot(hcAnnot);
        }
    }

    public static void attachSoapBindingAnnotation(TMAnnotationComposite composite, AnnotatedElement annotatedElement) {
        SOAPBinding soapBinding = (SOAPBinding)ConverterUtils.getAnnotation(SOAPBinding.class, annotatedElement);
        if (soapBinding != null) {
            SoapBindingAnnot sbAnnot = ConverterUtils.createSoapBindingAnnot(soapBinding);
            composite.setSoapBindingAnnot(sbAnnot);
        }
    }

    public static void attachWebServiceRefAnnotation(TMFAnnotationComposite composite, AnnotatedElement annotatedElement) {
        WebServiceRef webServiceRef = (WebServiceRef)ConverterUtils.getAnnotation(WebServiceRef.class, annotatedElement);
        if (webServiceRef != null) {
            WebServiceRefAnnot wsrAnnot = ConverterUtils.createWebServiceRefAnnot(webServiceRef);
            composite.setWebServiceRefAnnot(wsrAnnot);
        }
    }

    public static void attachFieldDescriptionComposites(DescriptionBuilderComposite composite, List<FieldDescriptionComposite> fdcList) {
        for (FieldDescriptionComposite fdc : fdcList) {
            composite.addFieldDescriptionComposite(fdc);
        }
    }

    public static void attachMethodDescriptionComposites(DescriptionBuilderComposite composite, List<MethodDescriptionComposite> mdcList) {
        for (MethodDescriptionComposite mdc : mdcList) {
            composite.addMethodDescriptionComposite(mdc);
            mdc.setDescriptionBuilderCompositeRef(composite);
        }
    }

    public static void attachParameterDescriptionComposites(List<ParameterDescriptionComposite> pdcList, MethodDescriptionComposite mdc) {
        for (ParameterDescriptionComposite pdc : pdcList) {
            mdc.addParameterDescriptionComposite(pdc);
            pdc.setMethodDescriptionCompositeRef(mdc);
        }
    }

    public static boolean isInherited(Method method, String declaringClass) {
        return !method.getDeclaringClass().getName().equals(declaringClass);
    }

    public static String getFullType(ParameterizedType pt, String paramType) {
        Type[] genericTypes;
        if (pt.getRawType() instanceof Class) {
            Class rawClass = (Class)pt.getRawType();
            paramType = paramType + rawClass.getName();
        }
        if ((genericTypes = pt.getActualTypeArguments()).length > 0) {
            paramType = paramType + "<";
            for (int i = 0; i < genericTypes.length; ++i) {
                Type type = genericTypes[i];
                paramType = ConverterUtils.getType(type, paramType);
                paramType = i != genericTypes.length - 1 ? paramType + ", " : paramType + ">";
            }
        }
        return paramType;
    }

    public static String getType(Type type, String paramType) {
        if (type instanceof Class) {
            paramType = paramType + ((Class)type).getName();
        } else if (type instanceof ParameterizedType) {
            paramType = ConverterUtils.getFullType((ParameterizedType)type, paramType);
        } else if (type instanceof WildcardType) {
            paramType = paramType + "?";
        } else if (type instanceof GenericArrayType) {
            paramType = ConverterUtils.getType(((GenericArrayType)type).getGenericComponentType(), paramType) + "[]";
        }
        return paramType;
    }

    public static boolean hasXmlListAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != XmlList.class) continue;
            return true;
        }
        return false;
    }
}

