/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.api;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.BreakIterator;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openjdk.javax.annotation.processing.ProcessingEnvironment;
import org.openjdk.javax.lang.model.element.AnnotationMirror;
import org.openjdk.javax.lang.model.element.AnnotationValue;
import org.openjdk.javax.lang.model.element.Element;
import org.openjdk.javax.lang.model.element.ElementKind;
import org.openjdk.javax.lang.model.element.ExecutableElement;
import org.openjdk.javax.lang.model.element.Modifier;
import org.openjdk.javax.lang.model.element.NestingKind;
import org.openjdk.javax.lang.model.element.PackageElement;
import org.openjdk.javax.lang.model.element.TypeElement;
import org.openjdk.javax.lang.model.type.DeclaredType;
import org.openjdk.javax.lang.model.type.ErrorType;
import org.openjdk.javax.lang.model.type.TypeKind;
import org.openjdk.javax.lang.model.type.TypeMirror;
import org.openjdk.javax.tools.Diagnostic;
import org.openjdk.javax.tools.FileObject;
import org.openjdk.javax.tools.ForwardingFileObject;
import org.openjdk.javax.tools.JavaCompiler;
import org.openjdk.javax.tools.JavaFileManager;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.javax.tools.StandardLocation;
import org.openjdk.source.doctree.DocCommentTree;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.source.tree.CatchTree;
import org.openjdk.source.tree.CompilationUnitTree;
import org.openjdk.source.tree.Scope;
import org.openjdk.source.tree.Tree;
import org.openjdk.source.util.DocSourcePositions;
import org.openjdk.source.util.DocTreePath;
import org.openjdk.source.util.DocTreeScanner;
import org.openjdk.source.util.DocTrees;
import org.openjdk.source.util.JavacTask;
import org.openjdk.source.util.TreePath;
import org.openjdk.tools.javac.api.BasicJavacTask;
import org.openjdk.tools.javac.api.JavacScope;
import org.openjdk.tools.javac.api.JavacTaskImpl;
import org.openjdk.tools.javac.code.AnnoConstruct;
import org.openjdk.tools.javac.code.Kinds;
import org.openjdk.tools.javac.code.Scope;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.code.Type;
import org.openjdk.tools.javac.code.TypeTag;
import org.openjdk.tools.javac.code.Types;
import org.openjdk.tools.javac.comp.Attr;
import org.openjdk.tools.javac.comp.AttrContext;
import org.openjdk.tools.javac.comp.Enter;
import org.openjdk.tools.javac.comp.Env;
import org.openjdk.tools.javac.comp.MemberEnter;
import org.openjdk.tools.javac.comp.Modules;
import org.openjdk.tools.javac.comp.Resolve;
import org.openjdk.tools.javac.file.BaseFileManager;
import org.openjdk.tools.javac.model.JavacElements;
import org.openjdk.tools.javac.parser.DocCommentParser;
import org.openjdk.tools.javac.parser.ParserFactory;
import org.openjdk.tools.javac.parser.Tokens;
import org.openjdk.tools.javac.processing.JavacProcessingEnvironment;
import org.openjdk.tools.javac.tree.DCTree;
import org.openjdk.tools.javac.tree.DocCommentTable;
import org.openjdk.tools.javac.tree.DocTreeMaker;
import org.openjdk.tools.javac.tree.EndPosTable;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.tree.TreeCopier;
import org.openjdk.tools.javac.tree.TreeInfo;
import org.openjdk.tools.javac.tree.TreeMaker;
import org.openjdk.tools.javac.util.Abort;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.DiagnosticSource;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Name;
import org.openjdk.tools.javac.util.Names;
import org.openjdk.tools.javac.util.Pair;
import org.openjdk.tools.javac.util.Position;

public class JavacTrees
extends DocTrees {
    private Modules modules;
    private Resolve resolve;
    private Enter enter;
    private Log log;
    private MemberEnter memberEnter;
    private Attr attr;
    private TreeMaker treeMaker;
    private JavacElements elements;
    private JavacTaskImpl javacTaskImpl;
    private Names names;
    private Types types;
    private DocTreeMaker docTreeMaker;
    private BreakIterator breakIterator = null;
    private JavaFileManager fileManager;
    private ParserFactory parser;
    private Symtab syms;
    Types.TypeRelation fuzzyMatcher = new Types.TypeRelation(){

        @Override
        public Boolean visitType(Type type, Type type2) {
            if (type == type2) {
                return true;
            }
            if (type2.isPartial()) {
                return (Boolean)this.visit(type2, type);
            }
            switch (type.getTag()) {
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: 
                case BOT: 
                case NONE: {
                    return type.hasTag(type2.getTag());
                }
            }
            throw new AssertionError((Object)("fuzzyMatcher " + (Object)((Object)type.getTag())));
        }

        @Override
        public Boolean visitArrayType(Type.ArrayType arrayType, Type type) {
            if (arrayType == type) {
                return true;
            }
            if (type.isPartial()) {
                return (Boolean)this.visit(type, arrayType);
            }
            return type.hasTag(TypeTag.ARRAY) && (Boolean)this.visit(arrayType.elemtype, JavacTrees.this.types.elemtype(type)) != false;
        }

        @Override
        public Boolean visitClassType(Type.ClassType classType, Type type) {
            if (classType == type) {
                return true;
            }
            if (type.isPartial()) {
                return (Boolean)this.visit(type, classType);
            }
            return classType.tsym == type.tsym;
        }

        @Override
        public Boolean visitErrorType(Type.ErrorType errorType, Type type) {
            return type.hasTag(TypeTag.CLASS) && errorType.tsym.name == ((Type.ClassType)type).tsym.name;
        }
    };

    public static JavacTrees instance(JavaCompiler.CompilationTask compilationTask) {
        if (!(compilationTask instanceof BasicJavacTask)) {
            throw new IllegalArgumentException();
        }
        return JavacTrees.instance(((BasicJavacTask)compilationTask).getContext());
    }

    public static JavacTrees instance(ProcessingEnvironment processingEnvironment) {
        if (!(processingEnvironment instanceof JavacProcessingEnvironment)) {
            throw new IllegalArgumentException();
        }
        return JavacTrees.instance(((JavacProcessingEnvironment)processingEnvironment).getContext());
    }

    public static JavacTrees instance(Context context) {
        JavacTrees javacTrees = context.get(JavacTrees.class);
        if (javacTrees == null) {
            javacTrees = new JavacTrees(context);
        }
        return javacTrees;
    }

    protected JavacTrees(Context context) {
        context.put(JavacTrees.class, this);
        this.init(context);
    }

    public void updateContext(Context context) {
        this.init(context);
    }

    private void init(Context context) {
        this.modules = Modules.instance(context);
        this.attr = Attr.instance(context);
        this.enter = Enter.instance(context);
        this.elements = JavacElements.instance(context);
        this.log = Log.instance(context);
        this.resolve = Resolve.instance(context);
        this.treeMaker = TreeMaker.instance(context);
        this.memberEnter = MemberEnter.instance(context);
        this.names = Names.instance(context);
        this.types = Types.instance(context);
        this.docTreeMaker = DocTreeMaker.instance(context);
        this.parser = ParserFactory.instance(context);
        this.syms = Symtab.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        JavacTask javacTask = context.get(JavacTask.class);
        if (javacTask instanceof JavacTaskImpl) {
            this.javacTaskImpl = (JavacTaskImpl)javacTask;
        }
    }

    @Override
    public BreakIterator getBreakIterator() {
        return this.breakIterator;
    }

    @Override
    public DocSourcePositions getSourcePositions() {
        return new DocSourcePositions(){

            @Override
            public long getStartPosition(CompilationUnitTree compilationUnitTree, Tree tree) {
                return TreeInfo.getStartPos((JCTree)tree);
            }

            @Override
            public long getEndPosition(CompilationUnitTree compilationUnitTree, Tree tree) {
                EndPosTable endPosTable = ((JCTree.JCCompilationUnit)compilationUnitTree).endPositions;
                return TreeInfo.getEndPos((JCTree)tree, endPosTable);
            }

            @Override
            public long getStartPosition(CompilationUnitTree compilationUnitTree, DocCommentTree docCommentTree, DocTree docTree) {
                return ((DCTree)docTree).getSourcePosition((DCTree.DCDocComment)docCommentTree);
            }

            @Override
            public long getEndPosition(CompilationUnitTree compilationUnitTree, DocCommentTree docCommentTree, DocTree docTree) {
                int n;
                DCTree.DCDocComment dCDocComment = (DCTree.DCDocComment)docCommentTree;
                if (docTree instanceof DCTree.DCEndPosTree && (n = ((DCTree.DCEndPosTree)docTree).getEndPos(dCDocComment)) != -1) {
                    return n;
                }
                n = 0;
                switch (docTree.getKind()) {
                    case TEXT: {
                        DCTree.DCText dCText = (DCTree.DCText)docTree;
                        return dCDocComment.comment.getSourcePos(dCText.pos + dCText.text.length());
                    }
                    case ERRONEOUS: {
                        DCTree.DCErroneous dCErroneous = (DCTree.DCErroneous)docTree;
                        return dCDocComment.comment.getSourcePos(dCErroneous.pos + dCErroneous.body.length());
                    }
                    case IDENTIFIER: {
                        DCTree.DCIdentifier dCIdentifier = (DCTree.DCIdentifier)docTree;
                        return dCDocComment.comment.getSourcePos(dCIdentifier.pos + (dCIdentifier.name != ((JavacTrees)JavacTrees.this).names.error ? dCIdentifier.name.length() : 0));
                    }
                    case PARAM: {
                        DCTree.DCParam dCParam = (DCTree.DCParam)docTree;
                        if (dCParam.isTypeParameter && dCParam.getDescription().isEmpty()) {
                            n = 1;
                        }
                    }
                    case AUTHOR: 
                    case DEPRECATED: 
                    case RETURN: 
                    case SEE: 
                    case SERIAL: 
                    case SERIAL_DATA: 
                    case SERIAL_FIELD: 
                    case SINCE: 
                    case THROWS: 
                    case UNKNOWN_BLOCK_TAG: 
                    case VERSION: {
                        DocTree docTree2 = JavacTrees.this.getLastChild(docTree);
                        if (docTree2 != null) {
                            return this.getEndPosition(compilationUnitTree, docCommentTree, docTree2) + (long)n;
                        }
                        DCTree.DCBlockTag dCBlockTag = (DCTree.DCBlockTag)docTree;
                        return dCDocComment.comment.getSourcePos(dCBlockTag.pos + dCBlockTag.getTagName().length() + 1);
                    }
                }
                DocTree docTree3 = JavacTrees.this.getLastChild(docTree);
                if (docTree3 != null) {
                    return this.getEndPosition(compilationUnitTree, docCommentTree, docTree3);
                }
                return -1L;
            }
        };
    }

    @Override
    public DocTreeMaker getDocTreeFactory() {
        return this.docTreeMaker;
    }

    private DocTree getLastChild(DocTree docTree) {
        final DocTree[] docTreeArray = new DocTree[]{null};
        docTree.accept(new DocTreeScanner<Void, Void>(){

            @Override
            public Void scan(DocTree docTree, Void void_) {
                if (docTree != null) {
                    docTreeArray[0] = docTree;
                }
                return null;
            }
        }, null);
        return docTreeArray[0];
    }

    @Override
    public JCTree.JCClassDecl getTree(TypeElement typeElement) {
        return (JCTree.JCClassDecl)this.getTree((Element)typeElement);
    }

    @Override
    public JCTree.JCMethodDecl getTree(ExecutableElement executableElement) {
        return (JCTree.JCMethodDecl)this.getTree((Element)executableElement);
    }

    @Override
    public JCTree getTree(Element element) {
        return this.getTree(element, null);
    }

    @Override
    public JCTree getTree(Element element, AnnotationMirror annotationMirror) {
        return this.getTree(element, annotationMirror, null);
    }

    @Override
    public JCTree getTree(Element element, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
        Pair<JCTree, JCTree.JCCompilationUnit> pair = this.elements.getTreeAndTopLevel(element, annotationMirror, annotationValue);
        if (pair == null) {
            return null;
        }
        return (JCTree)pair.fst;
    }

    @Override
    public TreePath getPath(CompilationUnitTree compilationUnitTree, Tree tree) {
        return TreePath.getPath(compilationUnitTree, tree);
    }

    @Override
    public TreePath getPath(Element element) {
        return this.getPath(element, null, null);
    }

    @Override
    public TreePath getPath(Element element, AnnotationMirror annotationMirror) {
        return this.getPath(element, annotationMirror, null);
    }

    @Override
    public TreePath getPath(Element element, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
        Pair<JCTree, JCTree.JCCompilationUnit> pair = this.elements.getTreeAndTopLevel(element, annotationMirror, annotationValue);
        if (pair == null) {
            return null;
        }
        return TreePath.getPath((CompilationUnitTree)pair.snd, (Tree)pair.fst);
    }

    @Override
    public Symbol getElement(TreePath treePath) {
        JCTree jCTree = (JCTree)treePath.getLeaf();
        Symbol symbol = TreeInfo.symbolFor(jCTree);
        if (symbol == null) {
            for (TreePath treePath2 = treePath; treePath2 != null; treePath2 = treePath2.getParentPath()) {
                JCTree jCTree2 = (JCTree)treePath2.getLeaf();
                if (!jCTree2.hasTag(JCTree.Tag.CLASSDEF)) continue;
                JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)jCTree2;
                if (jCClassDecl.sym == null) continue;
                if ((jCClassDecl.sym.flags_field & 0x10000000L) == 0L) break;
                this.attr.attribClass(jCClassDecl.pos(), jCClassDecl.sym);
                symbol = TreeInfo.symbolFor(jCTree);
                break;
            }
        }
        return symbol;
    }

    @Override
    public Element getElement(DocTreePath docTreePath) {
        DocTree docTree = docTreePath.getLeaf();
        if (docTree instanceof DCTree.DCReference) {
            return this.attributeDocReference(docTreePath.getTreePath(), (DCTree.DCReference)docTree);
        }
        if (docTree instanceof DCTree.DCIdentifier && docTreePath.getParentPath().getLeaf() instanceof DCTree.DCParam) {
            return this.attributeParamIdentifier(docTreePath.getTreePath(), (DCTree.DCParam)docTreePath.getParentPath().getLeaf());
        }
        return null;
    }

    @Override
    public java.util.List<DocTree> getFirstSentence(java.util.List<? extends DocTree> list) {
        return this.docTreeMaker.getFirstSentence(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Symbol attributeDocReference(TreePath treePath, DCTree.DCReference dCReference) {
        Name name;
        Env<AttrContext> env = this.getAttrContext(treePath);
        if (env == null) {
            return null;
        }
        Log.DeferredDiagnosticHandler deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(this.log);
        try {
            Object object;
            void var5_10;
            Object object2;
            List list;
            Object object3;
            Object object4;
            if (dCReference.qualifierExpression == null) {
                Symbol.ClassSymbol classSymbol = env.enclClass.sym;
                name = (Name)dCReference.memberName;
            } else {
                object4 = this.attr.attribType(dCReference.qualifierExpression, env);
                if (((Type)object4).isErroneous()) {
                    object3 = this.treeMaker.TopLevel(List.nil());
                    list = this.modules.getDefaultModule();
                    ((JCTree.JCCompilationUnit)object3).modle = list;
                    ((JCTree.JCCompilationUnit)object3).packge = ((Symbol.ModuleSymbol)((Object)list)).unnamedPackage;
                    object2 = this.attr.attribIdent(dCReference.qualifierExpression, (JCTree.JCCompilationUnit)object3);
                    ((Symbol)object2).complete();
                    if ((((Symbol)object2).kind == Kinds.Kind.PCK || ((Symbol)object2).kind == Kinds.Kind.TYP) && ((Symbol)object2).exists()) {
                        Symbol.TypeSymbol typeSymbol = (Symbol.TypeSymbol)object2;
                        name = (Name)dCReference.memberName;
                        if (((Symbol)object2).kind == Kinds.Kind.PCK && name != null) {
                            Symbol symbol = null;
                            return symbol;
                        }
                    } else {
                        if (!dCReference.qualifierExpression.hasTag(JCTree.Tag.IDENT)) {
                            Symbol symbol = null;
                            return symbol;
                        }
                        Symbol.ClassSymbol classSymbol = env.enclClass.sym;
                        name = ((JCTree.JCIdent)dCReference.qualifierExpression).name;
                    }
                } else {
                    Symbol.TypeSymbol typeSymbol = ((Type)object4).tsym;
                    name = (Name)dCReference.memberName;
                }
            }
            if (name == null) {
                object4 = var5_10;
                return object4;
            }
            if (dCReference.paramTypes == null) {
                object4 = null;
            } else {
                object3 = new ListBuffer();
                list = (List)dCReference.paramTypes;
                while (list.nonEmpty()) {
                    object2 = (JCTree)list.head;
                    object = this.attr.attribType((JCTree)object2, env);
                    ((ListBuffer)object3).add(object);
                    list = list.tail;
                }
                object4 = ((ListBuffer)object3).toList();
            }
            object3 = (Symbol.ClassSymbol)this.types.skipTypeVars((Type)var5_10.type, (boolean)false).tsym;
            List list2 = list = name == ((Symbol.ClassSymbol)object3).name ? this.findConstructor((Symbol.ClassSymbol)object3, (List<Type>)object4) : this.findMethod((Symbol.ClassSymbol)object3, name, (List<Type>)object4);
            if (object4 != null) {
                object2 = list;
                return object2;
            }
            Object object5 = object2 = dCReference.paramTypes != null ? null : this.findField((Symbol.ClassSymbol)object3, name);
            if (object2 != null && (list == null || this.types.isSubtypeUnchecked((Type)((Symbol)object2).enclClass().asType(), (Type)((Symbol)((Object)list)).enclClass().asType()))) {
                object = object2;
                return object;
            }
            object = list;
            return object;
        }
        catch (Abort abort) {
            name = null;
            return name;
        }
        finally {
            this.log.popDiagnosticHandler(deferredDiagnosticHandler);
        }
    }

    private Symbol attributeParamIdentifier(TreePath treePath, DCTree.DCParam dCParam) {
        Object object;
        Symbol symbol = this.getElement(treePath);
        if (symbol == null) {
            return null;
        }
        ElementKind elementKind = symbol.getKind();
        java.util.List list = List.nil();
        if (elementKind == ElementKind.METHOD || elementKind == ElementKind.CONSTRUCTOR) {
            object = (Symbol.MethodSymbol)symbol;
            list = dCParam.isTypeParameter() ? ((Symbol.MethodSymbol)object).getTypeParameters() : ((Symbol.MethodSymbol)object).getParameters();
        } else if (elementKind.isClass() || elementKind.isInterface()) {
            object = (Symbol.ClassSymbol)symbol;
            list = ((Symbol.ClassSymbol)object).getTypeParameters();
        }
        for (Symbol symbol2 : list) {
            if (symbol2.getSimpleName() != dCParam.getName().getName()) continue;
            return symbol2;
        }
        return null;
    }

    private Symbol.VarSymbol findField(Symbol.ClassSymbol classSymbol, Name name) {
        return this.searchField(classSymbol, name, new HashSet<Symbol.ClassSymbol>());
    }

    private Symbol.VarSymbol searchField(Symbol.ClassSymbol classSymbol, Name name, Set<Symbol.ClassSymbol> set) {
        Object object;
        AnnoConstruct annoConstruct2;
        if (set.contains(classSymbol)) {
            return null;
        }
        set.add(classSymbol);
        for (AnnoConstruct annoConstruct2 : classSymbol.members().getSymbolsByName(name)) {
            if (annoConstruct2.kind != Kinds.Kind.VAR) continue;
            return (Symbol.VarSymbol)annoConstruct2;
        }
        Symbol.ClassSymbol classSymbol2 = classSymbol.owner.enclClass();
        if (classSymbol2 != null && (annoConstruct2 = this.searchField(classSymbol2, name, set)) != null) {
            return annoConstruct2;
        }
        annoConstruct2 = classSymbol.getSuperclass();
        if (((Type)annoConstruct2).tsym != null && (object = this.searchField((Symbol.ClassSymbol)((Type)annoConstruct2).tsym, name, set)) != null) {
            return object;
        }
        object = classSymbol.getInterfaces();
        List list = object;
        while (list.nonEmpty()) {
            Symbol.VarSymbol varSymbol;
            Type type = (Type)list.head;
            if (!type.isErroneous() && (varSymbol = this.searchField((Symbol.ClassSymbol)type.tsym, name, set)) != null) {
                return varSymbol;
            }
            list = list.tail;
        }
        return null;
    }

    Symbol.MethodSymbol findConstructor(Symbol.ClassSymbol classSymbol, List<Type> list) {
        for (Symbol symbol : classSymbol.members().getSymbolsByName(this.names.init)) {
            if (symbol.kind != Kinds.Kind.MTH || !this.hasParameterTypes((Symbol.MethodSymbol)symbol, list)) continue;
            return (Symbol.MethodSymbol)symbol;
        }
        return null;
    }

    private Symbol.MethodSymbol findMethod(Symbol.ClassSymbol classSymbol, Name name, List<Type> list) {
        return this.searchMethod(classSymbol, name, list, new HashSet<Symbol.ClassSymbol>());
    }

    private Symbol.MethodSymbol searchMethod(Symbol.ClassSymbol classSymbol, Name name, List<Type> list, Set<Symbol.ClassSymbol> set) {
        AnnoConstruct annoConstruct;
        Symbol.MethodSymbol methodSymbol;
        Object object2;
        Object object3;
        if (name == this.names.init) {
            return null;
        }
        if (set.contains(classSymbol)) {
            return null;
        }
        set.add(classSymbol);
        if (list == null) {
            object3 = null;
            for (Object object2 : classSymbol.members().getSymbolsByName(name)) {
                if (((Symbol)object2).kind != Kinds.Kind.MTH || ((Symbol)object2).name != name) continue;
                object3 = (Symbol.MethodSymbol)object2;
            }
            if (object3 != null) {
                return object3;
            }
        } else {
            for (Symbol symbol : classSymbol.members().getSymbolsByName(name)) {
                if (symbol == null || symbol.kind != Kinds.Kind.MTH || !this.hasParameterTypes((Symbol.MethodSymbol)symbol, list)) continue;
                return (Symbol.MethodSymbol)symbol;
            }
        }
        object3 = classSymbol.getSuperclass();
        if (((Type)object3).tsym != null && (methodSymbol = this.searchMethod((Symbol.ClassSymbol)((Type)object3).tsym, name, list, set)) != null) {
            return methodSymbol;
        }
        java.util.List list2 = classSymbol.getInterfaces();
        object2 = list2;
        while (((List)object2).nonEmpty()) {
            Symbol.MethodSymbol methodSymbol2;
            annoConstruct = (Type)((List)object2).head;
            if (!annoConstruct.isErroneous() && (methodSymbol2 = this.searchMethod((Symbol.ClassSymbol)annoConstruct.tsym, name, list, set)) != null) {
                return methodSymbol2;
            }
            object2 = ((List)object2).tail;
        }
        object2 = classSymbol.owner.enclClass();
        if (object2 != null && (annoConstruct = this.searchMethod((Symbol.ClassSymbol)object2, name, list, set)) != null) {
            return annoConstruct;
        }
        return null;
    }

    private boolean hasParameterTypes(Symbol.MethodSymbol methodSymbol, List<Type> list) {
        if (list == null) {
            return true;
        }
        if (methodSymbol.params().size() != list.size()) {
            return false;
        }
        List<Type> list2 = this.types.erasureRecursive((Type)methodSymbol.asType()).getParameterTypes();
        return Type.isErroneous(list) ? this.fuzzyMatch(list, list2) : this.types.isSameTypes(list, list2);
    }

    boolean fuzzyMatch(List<Type> list, List<Type> list2) {
        List<Type> list3 = list;
        List<Type> list4 = list2;
        while (list3.nonEmpty()) {
            if (!this.fuzzyMatch((Type)list3.head, (Type)list4.head)) {
                return false;
            }
            list3 = list3.tail;
            list4 = list4.tail;
        }
        return true;
    }

    boolean fuzzyMatch(Type type, Type type2) {
        Boolean bl = (Boolean)this.fuzzyMatcher.visit(type, type2);
        return bl == Boolean.TRUE;
    }

    @Override
    public TypeMirror getTypeMirror(TreePath treePath) {
        Tree tree = treePath.getLeaf();
        Type type = ((JCTree)tree).type;
        return type == null ? null : type.stripMetadataIfNeeded();
    }

    @Override
    public JavacScope getScope(TreePath treePath) {
        return JavacScope.create(this.getAttrContext(treePath));
    }

    @Override
    public String getDocComment(TreePath treePath) {
        CompilationUnitTree compilationUnitTree = treePath.getCompilationUnit();
        Tree tree = treePath.getLeaf();
        if (compilationUnitTree instanceof JCTree.JCCompilationUnit && tree instanceof JCTree) {
            JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)compilationUnitTree;
            if (jCCompilationUnit.docComments != null) {
                return jCCompilationUnit.docComments.getCommentText((JCTree)tree);
            }
        }
        return null;
    }

    @Override
    public DocCommentTree getDocCommentTree(TreePath treePath) {
        CompilationUnitTree compilationUnitTree = treePath.getCompilationUnit();
        Tree tree = treePath.getLeaf();
        if (compilationUnitTree instanceof JCTree.JCCompilationUnit && tree instanceof JCTree) {
            JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)compilationUnitTree;
            if (jCCompilationUnit.docComments != null) {
                return jCCompilationUnit.docComments.getCommentTree((JCTree)tree);
            }
        }
        return null;
    }

    @Override
    public DocCommentTree getDocCommentTree(Element element) {
        TreePath treePath = this.getPath(element);
        if (treePath == null) {
            return null;
        }
        return this.getDocCommentTree(treePath);
    }

    @Override
    public DocCommentTree getDocCommentTree(Element element, String string) throws IOException {
        PackageElement packageElement = this.elements.getPackageOf(element);
        FileObject fileObject = this.fileManager.getFileForInput(StandardLocation.SOURCE_PATH, packageElement.getQualifiedName().toString(), string);
        if (fileObject == null) {
            throw new FileNotFoundException(string);
        }
        return this.getDocCommentTree(fileObject);
    }

    @Override
    public boolean isAccessible(Scope scope, TypeElement typeElement) {
        if (scope instanceof JavacScope && typeElement instanceof Symbol.ClassSymbol) {
            Env<AttrContext> env = ((JavacScope)scope).env;
            return this.resolve.isAccessible(env, (Symbol.ClassSymbol)typeElement, true);
        }
        return false;
    }

    @Override
    public boolean isAccessible(Scope scope, Element element, DeclaredType declaredType) {
        if (scope instanceof JavacScope && element instanceof Symbol && declaredType instanceof Type) {
            Env<AttrContext> env = ((JavacScope)scope).env;
            return this.resolve.isAccessible(env, (Type)((Object)declaredType), (Symbol)element, true);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Env<AttrContext> getAttrContext(TreePath treePath) {
        if (!(treePath.getLeaf() instanceof JCTree)) {
            throw new IllegalArgumentException();
        }
        if (this.javacTaskImpl != null) {
            this.javacTaskImpl.enter(null);
        }
        JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)treePath.getCompilationUnit();
        Copier copier = this.createCopier(this.treeMaker.forToplevel(jCCompilationUnit));
        Env<AttrContext> env = null;
        JCTree.JCMethodDecl jCMethodDecl = null;
        JCTree.JCVariableDecl jCVariableDecl = null;
        List<Tree> list = List.nil();
        for (TreePath treePath2 = treePath; treePath2 != null; treePath2 = treePath2.getParentPath()) {
            list = list.prepend(treePath2.getLeaf());
        }
        while (list.nonEmpty()) {
            Tree tree = (Tree)list.head;
            switch (tree.getKind()) {
                case COMPILATION_UNIT: {
                    env = this.enter.getTopLevelEnv((JCTree.JCCompilationUnit)tree);
                    break;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    env = this.enter.getClassEnv(((JCTree.JCClassDecl)tree).sym);
                    if (env != null) break;
                    return null;
                }
                case METHOD: {
                    jCMethodDecl = (JCTree.JCMethodDecl)tree;
                    env = this.memberEnter.getMethodEnv(jCMethodDecl, env);
                    break;
                }
                case VARIABLE: {
                    jCVariableDecl = (JCTree.JCVariableDecl)tree;
                    break;
                }
                case BLOCK: {
                    if (jCMethodDecl != null) {
                        try {
                            Assert.check(jCMethodDecl.body == tree);
                            jCMethodDecl.body = copier.copy((JCTree.JCBlock)tree, (JCTree)treePath.getLeaf());
                            env = this.attribStatToTree(jCMethodDecl.body, env, copier.leafCopy);
                        }
                        finally {
                            jCMethodDecl.body = (JCTree.JCBlock)tree;
                        }
                    } else {
                        JCTree.JCBlock jCBlock = copier.copy((JCTree.JCBlock)tree, (JCTree)treePath.getLeaf());
                        env = this.attribStatToTree(jCBlock, env, copier.leafCopy);
                    }
                    return env;
                }
                default: {
                    if (jCVariableDecl == null || jCVariableDecl.getInitializer() != tree) break;
                    env = this.memberEnter.getInitEnv(jCVariableDecl, env);
                    JCTree.JCExpression jCExpression = copier.copy((JCTree.JCExpression)tree, (JCTree)treePath.getLeaf());
                    env = this.attribExprToTree(jCExpression, env, copier.leafCopy);
                    return env;
                }
            }
            list = list.tail;
        }
        return jCVariableDecl != null ? this.memberEnter.getInitEnv(jCVariableDecl, env) : env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Env<AttrContext> attribStatToTree(JCTree jCTree, Env<AttrContext> env, JCTree jCTree2) {
        JavaFileObject javaFileObject = this.log.useSource(env.toplevel.sourcefile);
        try {
            Env<AttrContext> env2 = this.attr.attribStatToTree(jCTree, env, jCTree2);
            return env2;
        }
        finally {
            this.log.useSource(javaFileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Env<AttrContext> attribExprToTree(JCTree.JCExpression jCExpression, Env<AttrContext> env, JCTree jCTree) {
        JavaFileObject javaFileObject = this.log.useSource(env.toplevel.sourcefile);
        try {
            Env<AttrContext> env2 = this.attr.attribExprToTree(jCExpression, env, jCTree);
            return env2;
        }
        finally {
            this.log.useSource(javaFileObject);
        }
    }

    static JavaFileObject asJavaFileObject(FileObject fileObject) {
        JavaFileObject javaFileObject = null;
        if (fileObject instanceof JavaFileObject) {
            javaFileObject = (JavaFileObject)fileObject;
            JavacTrees.checkHtmlKind(fileObject, JavaFileObject.Kind.HTML);
            return javaFileObject;
        }
        JavacTrees.checkHtmlKind(fileObject);
        javaFileObject = new HtmlFileObject(fileObject);
        return javaFileObject;
    }

    private static void checkHtmlKind(FileObject fileObject) {
        JavacTrees.checkHtmlKind(fileObject, BaseFileManager.getKind(fileObject.getName()));
    }

    private static void checkHtmlKind(FileObject fileObject, JavaFileObject.Kind kind) {
        if (kind != JavaFileObject.Kind.HTML) {
            throw new IllegalArgumentException("HTML file expected:" + fileObject.getName());
        }
    }

    @Override
    public DocCommentTree getDocCommentTree(final FileObject fileObject) {
        JavaFileObject javaFileObject = JavacTrees.asJavaFileObject(fileObject);
        DiagnosticSource diagnosticSource = new DiagnosticSource(javaFileObject, this.log);
        Tokens.Comment comment = new Tokens.Comment(){
            int offset = 0;

            @Override
            public String getText() {
                try {
                    CharSequence charSequence = fileObject.getCharContent(true);
                    Pattern pattern = Pattern.compile("(?is).*?<body\\b[^>]*>(.*)</body\\b.*");
                    Matcher matcher = pattern.matcher(charSequence);
                    if (matcher.matches()) {
                        this.offset = matcher.end(1);
                        return matcher.group(1);
                    }
                    return "";
                }
                catch (IOException iOException) {
                    return "";
                }
            }

            @Override
            public int getSourcePos(int n) {
                return this.offset + n;
            }

            @Override
            public Tokens.Comment.CommentStyle getStyle() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isDeprecated() {
                throw new UnsupportedOperationException();
            }
        };
        return new DocCommentParser(this.parser, diagnosticSource, comment).parse();
    }

    @Override
    public DocTreePath getDocTreePath(FileObject fileObject, PackageElement packageElement) {
        JavaFileObject javaFileObject = JavacTrees.asJavaFileObject(fileObject);
        DocCommentTree docCommentTree = this.getDocCommentTree(javaFileObject);
        TreePath treePath = this.makeTreePath((Symbol.PackageSymbol)packageElement, javaFileObject, docCommentTree);
        return new DocTreePath(treePath, docCommentTree);
    }

    @Override
    public void setBreakIterator(BreakIterator breakIterator) {
        this.breakIterator = breakIterator;
    }

    protected Copier createCopier(TreeMaker treeMaker) {
        return new Copier(treeMaker);
    }

    @Override
    public TypeMirror getOriginalType(ErrorType errorType) {
        if (errorType instanceof Type.ErrorType) {
            return ((Type.ErrorType)errorType).getOriginalType();
        }
        return Type.noType;
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence charSequence, Tree tree, CompilationUnitTree compilationUnitTree) {
        this.printMessage(kind, charSequence, ((JCTree)tree).pos(), compilationUnitTree);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence charSequence, DocTree docTree, DocCommentTree docCommentTree, CompilationUnitTree compilationUnitTree) {
        this.printMessage(kind, charSequence, ((DCTree)docTree).pos((DCTree.DCDocComment)docCommentTree), compilationUnitTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void printMessage(Diagnostic.Kind kind, CharSequence charSequence, JCDiagnostic.DiagnosticPosition diagnosticPosition, CompilationUnitTree compilationUnitTree) {
        JavaFileObject javaFileObject = null;
        JavaFileObject javaFileObject2 = null;
        javaFileObject2 = compilationUnitTree.getSourceFile();
        if (javaFileObject2 == null) {
            diagnosticPosition = null;
        } else {
            javaFileObject = this.log.useSource(javaFileObject2);
        }
        try {
            switch (kind) {
                case ERROR: {
                    this.log.error(JCDiagnostic.DiagnosticFlag.MULTIPLE, diagnosticPosition, "proc.messager", charSequence.toString());
                    return;
                }
                case WARNING: {
                    this.log.warning(diagnosticPosition, "proc.messager", charSequence.toString());
                    return;
                }
                case MANDATORY_WARNING: {
                    this.log.mandatoryWarning(diagnosticPosition, "proc.messager", charSequence.toString());
                    return;
                }
                default: {
                    this.log.note(diagnosticPosition, "proc.messager", charSequence.toString());
                    return;
                }
            }
        }
        finally {
            if (javaFileObject != null) {
                this.log.useSource(javaFileObject);
            }
        }
    }

    @Override
    public TypeMirror getLub(CatchTree catchTree) {
        JCTree.JCCatch jCCatch = (JCTree.JCCatch)catchTree;
        JCTree.JCVariableDecl jCVariableDecl = jCCatch.param;
        if (jCVariableDecl.type != null && jCVariableDecl.type.getKind() == TypeKind.UNION) {
            Type.UnionClassType unionClassType = (Type.UnionClassType)jCVariableDecl.type;
            return unionClassType.getLub();
        }
        return jCVariableDecl.type;
    }

    private TreePath makeTreePath(Symbol.PackageSymbol packageSymbol, final JavaFileObject javaFileObject, final DocCommentTree docCommentTree) {
        JCTree.JCCompilationUnit jCCompilationUnit = new JCTree.JCCompilationUnit(List.nil()){

            public int getPos() {
                return 0;
            }

            public JavaFileObject getSourcefile() {
                return javaFileObject;
            }

            @Override
            public Position.LineMap getLineMap() {
                try {
                    CharSequence charSequence = javaFileObject.getCharContent(true);
                    String string = charSequence.toString();
                    return Position.makeLineMap(string.toCharArray(), string.length(), true);
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        };
        jCCompilationUnit.docComments = new DocCommentTable(){

            @Override
            public boolean hasComment(JCTree jCTree) {
                return false;
            }

            @Override
            public Tokens.Comment getComment(JCTree jCTree) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getCommentText(JCTree jCTree) {
                throw new UnsupportedOperationException();
            }

            @Override
            public DCTree.DCDocComment getCommentTree(JCTree jCTree) {
                return (DCTree.DCDocComment)docCommentTree;
            }

            @Override
            public void putComment(JCTree jCTree, Tokens.Comment comment) {
                throw new UnsupportedOperationException();
            }
        };
        jCCompilationUnit.lineMap = jCCompilationUnit.getLineMap();
        jCCompilationUnit.modle = packageSymbol.modle;
        jCCompilationUnit.sourcefile = javaFileObject;
        jCCompilationUnit.namedImportScope = new Scope.NamedImportScope(packageSymbol, jCCompilationUnit.toplevelScope);
        jCCompilationUnit.packge = packageSymbol;
        jCCompilationUnit.starImportScope = new Scope.StarImportScope(packageSymbol);
        jCCompilationUnit.toplevelScope = Scope.WriteableScope.create(packageSymbol);
        return new TreePath(jCCompilationUnit);
    }

    protected static class Copier
    extends TreeCopier<JCTree> {
        JCTree leafCopy = null;

        protected Copier(TreeMaker treeMaker) {
            super(treeMaker);
        }

        @Override
        public <T extends JCTree> T copy(T t, JCTree jCTree) {
            T t2 = super.copy(t, jCTree);
            if (t == jCTree) {
                this.leafCopy = t2;
            }
            return t2;
        }
    }

    private static class HtmlFileObject
    extends ForwardingFileObject<FileObject>
    implements JavaFileObject {
        public HtmlFileObject(FileObject fileObject) {
            super(fileObject);
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return BaseFileManager.getKind(this.fileObject.getName());
        }

        @Override
        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            return false;
        }

        @Override
        public NestingKind getNestingKind() {
            return null;
        }

        @Override
        public Modifier getAccessLevel() {
            return null;
        }
    }
}

