/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.source.util;

import org.openjdk.source.doctree.AttributeTree;
import org.openjdk.source.doctree.AuthorTree;
import org.openjdk.source.doctree.CommentTree;
import org.openjdk.source.doctree.DeprecatedTree;
import org.openjdk.source.doctree.DocCommentTree;
import org.openjdk.source.doctree.DocRootTree;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.source.doctree.DocTreeVisitor;
import org.openjdk.source.doctree.EndElementTree;
import org.openjdk.source.doctree.EntityTree;
import org.openjdk.source.doctree.ErroneousTree;
import org.openjdk.source.doctree.HiddenTree;
import org.openjdk.source.doctree.IdentifierTree;
import org.openjdk.source.doctree.IndexTree;
import org.openjdk.source.doctree.InheritDocTree;
import org.openjdk.source.doctree.LinkTree;
import org.openjdk.source.doctree.LiteralTree;
import org.openjdk.source.doctree.ParamTree;
import org.openjdk.source.doctree.ProvidesTree;
import org.openjdk.source.doctree.ReferenceTree;
import org.openjdk.source.doctree.ReturnTree;
import org.openjdk.source.doctree.SeeTree;
import org.openjdk.source.doctree.SerialDataTree;
import org.openjdk.source.doctree.SerialFieldTree;
import org.openjdk.source.doctree.SerialTree;
import org.openjdk.source.doctree.SinceTree;
import org.openjdk.source.doctree.StartElementTree;
import org.openjdk.source.doctree.TextTree;
import org.openjdk.source.doctree.ThrowsTree;
import org.openjdk.source.doctree.UnknownBlockTagTree;
import org.openjdk.source.doctree.UnknownInlineTagTree;
import org.openjdk.source.doctree.UsesTree;
import org.openjdk.source.doctree.ValueTree;
import org.openjdk.source.doctree.VersionTree;

public class DocTreeScanner<R, P>
implements DocTreeVisitor<R, P> {
    public R scan(DocTree docTree, P p) {
        return docTree == null ? null : (R)docTree.accept(this, p);
    }

    private R scanAndReduce(DocTree docTree, P p, R r) {
        return this.reduce(this.scan(docTree, p), r);
    }

    public R scan(Iterable<? extends DocTree> iterable, P p) {
        R r = null;
        if (iterable != null) {
            boolean bl = true;
            for (DocTree docTree : iterable) {
                r = (R)(bl ? this.scan(docTree, p) : this.scanAndReduce(docTree, p, r));
                bl = false;
            }
        }
        return r;
    }

    private R scanAndReduce(Iterable<? extends DocTree> iterable, P p, R r) {
        return this.reduce(this.scan(iterable, p), r);
    }

    public R reduce(R r, R r2) {
        return r;
    }

    @Override
    public R visitAttribute(AttributeTree attributeTree, P p) {
        return null;
    }

    @Override
    public R visitAuthor(AuthorTree authorTree, P p) {
        return this.scan(authorTree.getName(), p);
    }

    @Override
    public R visitComment(CommentTree commentTree, P p) {
        return null;
    }

    @Override
    public R visitDeprecated(DeprecatedTree deprecatedTree, P p) {
        return this.scan(deprecatedTree.getBody(), p);
    }

    @Override
    public R visitDocComment(DocCommentTree docCommentTree, P p) {
        R r = this.scan(docCommentTree.getFirstSentence(), p);
        r = this.scanAndReduce(docCommentTree.getBody(), p, r);
        r = this.scanAndReduce(docCommentTree.getBlockTags(), p, r);
        return r;
    }

    @Override
    public R visitDocRoot(DocRootTree docRootTree, P p) {
        return null;
    }

    @Override
    public R visitEndElement(EndElementTree endElementTree, P p) {
        return null;
    }

    @Override
    public R visitEntity(EntityTree entityTree, P p) {
        return null;
    }

    @Override
    public R visitErroneous(ErroneousTree erroneousTree, P p) {
        return null;
    }

    @Override
    public R visitHidden(HiddenTree hiddenTree, P p) {
        return this.scan(hiddenTree.getBody(), p);
    }

    @Override
    public R visitIdentifier(IdentifierTree identifierTree, P p) {
        return null;
    }

    @Override
    public R visitIndex(IndexTree indexTree, P p) {
        R r = this.scan(indexTree.getSearchTerm(), p);
        r = this.scanAndReduce(indexTree.getDescription(), p, r);
        return r;
    }

    @Override
    public R visitInheritDoc(InheritDocTree inheritDocTree, P p) {
        return null;
    }

    @Override
    public R visitLink(LinkTree linkTree, P p) {
        R r = this.scan(linkTree.getReference(), p);
        r = this.scanAndReduce(linkTree.getLabel(), p, r);
        return r;
    }

    @Override
    public R visitLiteral(LiteralTree literalTree, P p) {
        return null;
    }

    @Override
    public R visitParam(ParamTree paramTree, P p) {
        R r = this.scan(paramTree.getName(), p);
        r = this.scanAndReduce(paramTree.getDescription(), p, r);
        return r;
    }

    @Override
    public R visitProvides(ProvidesTree providesTree, P p) {
        R r = this.scan(providesTree.getServiceType(), p);
        r = this.scanAndReduce(providesTree.getDescription(), p, r);
        return r;
    }

    @Override
    public R visitReference(ReferenceTree referenceTree, P p) {
        return null;
    }

    @Override
    public R visitReturn(ReturnTree returnTree, P p) {
        return this.scan(returnTree.getDescription(), p);
    }

    @Override
    public R visitSee(SeeTree seeTree, P p) {
        return this.scan(seeTree.getReference(), p);
    }

    @Override
    public R visitSerial(SerialTree serialTree, P p) {
        return this.scan(serialTree.getDescription(), p);
    }

    @Override
    public R visitSerialData(SerialDataTree serialDataTree, P p) {
        return this.scan(serialDataTree.getDescription(), p);
    }

    @Override
    public R visitSerialField(SerialFieldTree serialFieldTree, P p) {
        R r = this.scan(serialFieldTree.getName(), p);
        r = this.scanAndReduce(serialFieldTree.getType(), p, r);
        r = this.scanAndReduce(serialFieldTree.getDescription(), p, r);
        return r;
    }

    @Override
    public R visitSince(SinceTree sinceTree, P p) {
        return this.scan(sinceTree.getBody(), p);
    }

    @Override
    public R visitStartElement(StartElementTree startElementTree, P p) {
        return this.scan(startElementTree.getAttributes(), p);
    }

    @Override
    public R visitText(TextTree textTree, P p) {
        return null;
    }

    @Override
    public R visitThrows(ThrowsTree throwsTree, P p) {
        R r = this.scan(throwsTree.getExceptionName(), p);
        r = this.scanAndReduce(throwsTree.getDescription(), p, r);
        return r;
    }

    @Override
    public R visitUnknownBlockTag(UnknownBlockTagTree unknownBlockTagTree, P p) {
        return this.scan(unknownBlockTagTree.getContent(), p);
    }

    @Override
    public R visitUnknownInlineTag(UnknownInlineTagTree unknownInlineTagTree, P p) {
        return this.scan(unknownInlineTagTree.getContent(), p);
    }

    @Override
    public R visitUses(UsesTree usesTree, P p) {
        R r = this.scan(usesTree.getServiceType(), p);
        r = this.scanAndReduce(usesTree.getDescription(), p, r);
        return r;
    }

    @Override
    public R visitValue(ValueTree valueTree, P p) {
        return this.scan(valueTree.getReference(), p);
    }

    @Override
    public R visitVersion(VersionTree versionTree, P p) {
        return this.scan(versionTree.getBody(), p);
    }

    @Override
    public R visitOther(DocTree docTree, P p) {
        return null;
    }
}

