/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.extensions.spring.receivers;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.axis2.AxisFault;
import org.apache.axis2.ServiceObjectSupplier;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.kernel.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringServletContextObjectSupplier
implements ServiceObjectSupplier {
    private static Log log = LogFactory.getLog(SpringServletContextObjectSupplier.class);
    public static final String SERVICE_SPRING_BEANNAME = "SpringBeanName";

    public Object getServiceObject(AxisService axisService) throws AxisFault {
        try {
            Parameter implBeanParam = axisService.getParameter(SERVICE_SPRING_BEANNAME);
            String beanName = ((String)implBeanParam.getValue()).trim();
            if (beanName != null) {
                Parameter servletConfigParam = axisService.getAxisConfiguration().getParameter(HTTPConstants.HTTP_SERVLETCONFIG);
                if (servletConfigParam == null) {
                    throw new Exception("Axis2 Can't find ServletConfigParameter");
                }
                Object obj = servletConfigParam.getValue();
                if (!(obj instanceof ServletConfig)) {
                    throw new Exception("Axis2 Can't find ServletConfig");
                }
                ServletConfig servletConfig = (ServletConfig)obj;
                ServletContext servletContext = servletConfig.getServletContext();
                WebApplicationContext aCtx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
                if (aCtx == null) {
                    log.warn((Object)"Axis2 Can't find Spring's ApplicationContext");
                    return null;
                }
                if (aCtx.getBean(beanName) == null) {
                    throw new Exception("Axis2 Can't find Spring Bean: " + beanName);
                }
                return aCtx.getBean(beanName);
            }
            throw new AxisFault(Messages.getMessage((String)"paramIsNotSpecified", (String)"SERVICE_SPRING_BEANNAME"));
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }
}

