/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: ConstantsAspect.java,v $
  Version:       $Name:  $ $Revision: 1.1 $
  Last Modified: $Date: 2006/02/20 16:56:30 $
 *****************************************************************************/
package org.ten60.netkernel.pingpong.representation;

import com.ten60.netkernel.urii.*;
import java.util.*;
/**
 * An aspect to hold the set of numeric constants
 * @author  tab
 */
public class ConstantsAspect implements IAspectConstants
{
	private final Map mConstants = new LinkedHashMap();
	
	/** Creates a new instance of ConstantsAspect with default values*/
	public ConstantsAspect()
	{	mConstants.put(BALL_COUNT, new Integer(2) );
		mConstants.put(BALL_RADIUS, new Integer(4) );
		mConstants.put(WALL_WIDTH, new Integer(600) );
		mConstants.put(WALL_HEIGHT, new Integer(300) );
		mConstants.put(DAMPING, new Float(0.001f) );
		mConstants.put(GRAVITY, new Float(0.0f) );
		mConstants.put(INITIAL_SPREAD, new Float(100.0f) );
		mConstants.put(INITIAL_VELOCITY, new Float(8.0f) );
		mConstants.put(INITIAL_VELOCITY_RADIANS, new Float(0.25f) );
		mConstants.put(BAT_WIDTH, new Integer(32) );
		mConstants.put(BAT_HEIGHT, new Integer(32) );
		mConstants.put(BALL_BAT_RESTITUTION, new Float(0.8f) );
		mConstants.put(BALL_BAT_FRICTION, new Float(0.25f) );
		mConstants.put(BALL_WALL_RESTITUTION, new Float(1.0f) );
		mConstants.put(BALL_WALL_FRICTION, new Float(0.0f) );
		mConstants.put(INTERACTION_RANGE, new Float(40.0f) );
		mConstants.put(ATTRACTION, new Float(0.00003f) );
		mConstants.put(REPULSION, new Float(0.2f) );
		mConstants.put(BALL_BALL_RESTITUTION, new Float(4.0f) );
	}
	
	public ConstantsAspect(IAspectConstants aOther)
	{	for (Iterator i=aOther.getNames(); i.hasNext(); )
		{	String name = (String)i.next();
			mConstants.put(name,aOther.getValue(name));
		}
	}
	
	public Iterator getNames()
	{	return mConstants.keySet().iterator();
	}
	
	public Number getValue(String aName)
	{	return (Number)mConstants.get(aName);
	}
	
	public void setValue(String aName, Number aNumber)
	{	mConstants.put(aName,aNumber);
	}
}