<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>
	<xsl:param name="param"/>
	
    <xsl:template match="/modules">
		<modules>
			<xsl:apply-templates/>
		</modules>
    </xsl:template>
	
	<xsl:template match="module">
		<xsl:variable name="uri" select="uri/text()"/>
		<xsl:variable name="version" select="version/text()"/>
		<module>
			<source>
				<xsl:variable name="source" select="$param/modules/module[identity/uri=$uri and identity/version=$version]/info/source"/>
				<xsl:choose>
					<xsl:when test="starts-with($source,'jar:')">
						<xsl:value-of select="substring($source,5,string-length($source)-6)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$source"/>
					</xsl:otherwise>
				</xsl:choose>
			</source>
		</module>
	</xsl:template>

</xsl:stylesheet> 
