/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: PerformInstallAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.12 $
 * Last Modified: $Date: 2006/08/20 18:20:45 $
 *****************************************************************************/
package org.ten60.netkernel.ext_install.installer.add;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.*;

import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier;
import org.ten60.netkernel.layer1.util.Utils;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.IAspectReadableBinaryStream;
import com.ten60.netkernel.module.ModuleManager;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.Version;

import java.util.jar.*;
import java.util.zip.*;
import java.net.*;
import java.util.*;
import java.io.*;
import org.w3c.dom.*;
/**
 *	Perform the install download and updates
 * @author  tab
 */
public class PerformInstallAccessor extends XAccessor
{
	public PerformInstallAccessor()
	{	declareArgument(XAccessor.OPERAND, true, false); // dependency doc
		declareArgument(XAccessor.PARAMETER, true, false); // module list
		declareArgument(XAccessor.OPERATOR, true, false); // control
		declareArgument("stats", true, false); // summry stats
	}
	

	protected IURRepresentation source(XAHelper aHelper) throws Exception
	{	
		IXDAReadOnly depend = aHelper.getOperand().getXDA();
		IXDAReadOnly operator = aHelper.getOperator().getXDA();
		DOMXDA deployed = new DOMXDA(aHelper.getParameter().getReadOnlyDocument(),true);
		IXDAReadOnly system = aHelper.getXResource(URI.create("netkernel:config")).getXDA();
		IXDAReadOnly modules = aHelper.getXResource(URI.create("netkernel:module")).getXDA();
		String downloadPath = system.getText("/system/modules", true);
		URI destDirURI = URI.create(getContainer().getBasePathURI()).resolve(downloadPath);
		File destDir = new File(destDirURI);
		if (!destDir.exists())
		{	destDir.mkdirs();
		}
		
		//backup deployedModules
		URI statsURI = aHelper.getURI("stats");
		IURRepresentation stats  = aHelper.getResource(statsURI,IURAspect.class);
		URI uri = URI.create("active:dpml+operand@ffcpl:/org/ten60/netkernel/ext_install/installer/rollback/backupDeployedModules.idoc+stats@"+statsURI.toString());
		Map values = new HashMap();
		values.put(statsURI,stats);
		IURRepresentation rollbackState = ((XAHelperExtra)aHelper).requestResourceWithValues(uri, IXAspect.class, values);
	
		boolean installSelected = operator.isTrue("/performInstall/installSelected");
		PollToAvoidDeadlockThread t = new PollToAvoidDeadlockThread(aHelper);
		t.start();
		for (IXDAReadOnlyIterator i = depend.readOnlyIterator("//dependencies/selected/modules/module"); i.hasNext(); )
		{	i.next();
			download(i,installSelected,destDir,deployed,modules,aHelper);
		}
		for (IXDAReadOnlyIterator i = depend.readOnlyIterator("//dependencies/available/modules/module"); i.hasNext(); )
		{	i.next();
			download(i,true,destDir,deployed,modules,aHelper);
		}
		for (IXDAReadOnlyIterator i = depend.readOnlyIterator("//dependencies/upgrade/modules/module"); i.hasNext(); )
		{	i.next();
			download(i,false,destDir,deployed,modules,aHelper);
		}
		t.setStopped();
		
		// update any fulcrums
		for (IXDAReadOnlyIterator i = depend.readOnlyIterator("/dependencies/fulcrums/modules/module"); i.hasNext(); )
		{	i.next();
			
			String uriString = i.getText("uri", true);
			String versionString = i.getText("version", true);
			String xpath = "/modules/module[identity/uri='"+uriString+"' and identity/version='"+versionString+"']";
			IXDAReadOnly fulcrumDef = modules.readOnlyIterator(xpath);
			URI fulcrumDefURI = URI.create(fulcrumDef.getText("info/source", true)+"module.xml");
			DOMXDA fulcrumDefDoc = new DOMXDA(aHelper.getXResource(fulcrumDefURI).getReadOnlyDocument(),true);
		
			//backup fulcrum config
			URI rollbackStateURI = URI.create("literal:var0");
			URI moduleURI = URI.create("literal:var1");
			IURMeta dummyMeta = new AlwaysExpiredMeta("text/xml",0);
			CompoundURIdentifier curi=new CompoundURIdentifier("active", "dpml");
			curi.addArg("operand", "ffcpl:/org/ten60/netkernel/ext_install/installer/rollback/backupModuleConfig.idoc");
			curi.addArg("config", fulcrumDefURI.toString() );
			curi.addArg("module", moduleURI.toString() );
			curi.addArg("state",  rollbackStateURI.toString());
			//uri = URI.create("active:dpml+operand@ffcpl:/org/ten60/netkernel/ext_install/installer/rollback/backupModuleConfig.idoc+config@"+CompoundURIdentifier.encode(fulcrumDefURI.toString())+"+module@"+moduleURI.toString()+"+state@"+rollbackStateURI.toString());
			uri=URI.create(curi.toString());
			values = new HashMap();
			values.put(rollbackStateURI,rollbackState);
			values.put(moduleURI,new MonoRepresentationImpl(dummyMeta, new StringAspect(i.toString())));
			rollbackState = ((XAHelperExtra)aHelper).requestResourceWithValues(uri, IXAspect.class, values);
			
			for (IXDAReadOnlyIterator j = depend.readOnlyIterator("/dependencies/selected/modules/module[type='application']"); j.hasNext(); )
			{	j.next();
				String appURIString = j.getText("uri", true);
				String message = "adding application ["+appURIString+"] to fulcrum ["+uriString+"]";
				SysLogger.log(SysLogger.CONTAINER, this, message);
				DOMXDA importFragment = new DOMXDA(XMLUtils.newDocument(),false);
				importFragment.appendPath("/", "import/uri", XMLUtils.escape(appURIString));
				fulcrumDefDoc.insertAfter(importFragment,"/","(/module/mapping/import)[last()]");
			}
			Version v = new Version(fulcrumDefDoc.getText("/module/identity/version", true));
			int[] n = v.getNumbers();
			n[n.length-1]++;
			v = new Version(n);
			fulcrumDefDoc.setText("/module/identity/version", v.toString(3));
			IURRepresentation fulcrumDefRep = serializeIndented(fulcrumDefDoc,aHelper);
			aHelper.setResource(fulcrumDefURI, fulcrumDefRep);
			
		}
		
		//update netkernel:module-list
		IURRepresentation rep = serializeIndented(deployed,aHelper);
		aHelper.setResource(URI.create("netkernel:module-list"), rep);
		
		// return rollbackState
		return rollbackState;
		
	}
	
	private void download(IXDAReadOnly aModule, boolean aInstall, File aDestDir, DOMXDA aDeployed, IXDAReadOnly aModules, XAHelper aHelper) throws Exception
	{
		String uriString = aModule.getText("uri", true);
		String versionString = aModule.getText("version", true);
		String sourceString = aModule.getText("source", true);
		boolean expand=aModule.isTrue("expand");
		
		String message = (aInstall?"installing":"updating")+" "+uriString+" v"+versionString+" from "+sourceString;
		SysLogger.log(SysLogger.CONTAINER, this, message);
		
		// determine destination filename
		int extIndex = sourceString.lastIndexOf('.');
		int baseIndex = sourceString.lastIndexOf('/',extIndex-1)+1;
		String filename = sourceString.substring(baseIndex);
		File destFile = new File(aDestDir, filename);
		if (destFile.exists())
		{	String extension = sourceString.substring(extIndex);
			String base = sourceString.substring(baseIndex,extIndex);
			int index = 1;
			do
			{	filename = base+"."+Integer.toString(index)+extension;
				destFile = new File(aDestDir, filename);
				index++;
			} while (destFile.exists());
		}
		
		//do the actual download
		IURRepresentation download = aHelper.getResource(URI.create(sourceString),IAspectReadableBinaryStream.class);
		
		IAspectReadableBinaryStream rbs = (IAspectReadableBinaryStream)download.getAspect(IAspectReadableBinaryStream.class);
		FileOutputStream fos = new FileOutputStream(destFile);
		Utils.pipe(rbs.getInputStream(), fos);
		
		if (uriString.equals(com.ten60.netkernel.container.Container.NETKERNEL_URN))
		{	// update bootloader with new kernel
			String bootloaderConfigData = destFile.toURI().getPath();
			SysLogger.log(SysLogger.CONTAINER, this, "updating bootloader kernel to "+bootloaderConfigData);
			IURAspect aspect = new StringAspect(bootloaderConfigData);
			IURMeta meta = new AlwaysExpiredMeta("text/plain", 0);
			IURRepresentation bootloaderConfigRep = new MonoRepresentationImpl(meta,aspect);
			aHelper.setResource(URI.create("netkernel:bootloader"), bootloaderConfigRep);
		}
		else
		{
			//expand jar if needed
			if (expand)
			{	String path=destFile.getAbsolutePath();
				extIndex = path.lastIndexOf('.');
				path=path.substring(0,extIndex)+File.separatorChar;
				File expandDir=new File(path);
				
				JarFile jf = new JarFile(destFile);
				for (Enumeration e=jf.entries(); e.hasMoreElements(); )
				{	JarEntry entry = (JarEntry)e.nextElement();
					if (!entry.isDirectory())
					{	String name=entry.getName();
						File dest=new File(expandDir,name);
						File dir=dest.getParentFile();
						if (!dir.exists())
						{	dir.mkdirs();
						}
						InputStream is=jf.getInputStream(entry);
						FileOutputStream os = new FileOutputStream(dest);
						Utils.pipe(is, os);
					}
				}
				destFile=expandDir;
			}
			
			//add to deployed modules
			if (!aInstall)
			{	// remove existing module(s)
				for (IXDAReadOnlyIterator i = aModules.readOnlyIterator("/modules/module[identity/uri='"+uriString+"']"); i.hasNext(); )
				{	i.next();
					String oldSourceString = i.getText("info/source",true);
					if (oldSourceString.startsWith("jar:"))
					{	oldSourceString=oldSourceString.substring(4,oldSourceString.length()-2);
					}
					aDeployed.rename("/modules/module[text()='"+oldSourceString+"']","disabled");
				}
			}
			String destUriString = destFile.toURI().toString();
			//windows hack to ensure triple backslash in URI
			if(File.separatorChar=='\\' && !destUriString.startsWith("file:///"))
			{	destUriString="file:///"+destUriString.substring(6);
			}
			aDeployed.appendPath("/modules", "module", XMLUtils.escape(destUriString));
			
			message = (aInstall?"installed":"updated")+" "+uriString+" v"+versionString+" to "+destFile.getAbsolutePath();
			SysLogger.log(SysLogger.CONTAINER, this, message);
			
		}
	}
	
	private IURRepresentation serializeIndented(DOMXDA aDoc, XAHelper aHelper) throws NetKernelException
	{
		XAHelperExtra extra = (XAHelperExtra)aHelper;
		CompoundURIdentifier serialiseURI = new CompoundURIdentifier("active", "serialize");
		serialiseURI.addArg(CompoundURIdentifier.OPD, "dummy.xml");
		serialiseURI.addArg(CompoundURIdentifier.OPT, "operator");
		Map args = new HashMap();
		args.put(URI.create("dummy.xml"), DOMXDAAspect.create(new AlwaysExpiredMeta("text/xml", 0), aDoc));
		String operator="<serialize><indent/></serialize>";
		args.put(URI.create("operator"), StringAspect.create(new AlwaysExpiredMeta("text/plain", 0), operator));
		IURRepresentation serialized = extra.requestResourceWithValues(serialiseURI.toJavaURI(), IURAspect.class, args);
		return serialized;
	}
	
	private class PollToAvoidDeadlockThread extends Thread
	{
		private XAHelper mHelper;
		private boolean mStopped=false;
		private IURRepresentation mRep;
		
		public PollToAvoidDeadlockThread(XAHelper aHelper)
		{	mHelper=aHelper;
		}
		
		public void setStopped()
		{	mStopped=true;
		}
		
		public void run()
		{	while (!mStopped)
			{	try
				{	Thread.currentThread().sleep(2000);
				} catch (InterruptedException e)
				{ ; }
				if (!mStopped)
				{	// do dummy poll
					try
					{	mRep=mHelper.getResource(URI.create("data:text/plain,0"), IURAspect.class);
						//System.out.println("polling...");
					}
					catch (NetKernelException e)
					{ ; }
				}
			}
		}
		
	}
	
}