/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: GetModuleDefinitionAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.2 $
 * Last Modified: $Date: 2004/08/05 10:39:42 $
 *****************************************************************************/
package org.ten60.netkernel.ext_install.installer.add;

import org.ten60.netkernel.ext_install.downloadServer.BuildAccessor;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.*;

import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.util.*;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.module.ModuleManager;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.Version;
import com.ten60.netkernel.urii.aspect.*;
import java.util.jar.*;
import java.io.*;
import java.net.*;
import java.util.*;
import org.w3c.dom.*;
/**
 *	Process dependencies needed on adding new modules
 * @author  tab
 */
public class GetModuleDefinitionAccessor extends XAccessor
{
	public GetModuleDefinitionAccessor()
	{	declareArgument(XAccessor.OPERAND, true, false); // nvp param with list of modules
	}
	
	protected IURRepresentation source(XAHelper aHelper) throws Exception
	{	
		URI operandURI = aHelper.getURI(XAHelper.OPERAND);
		DOMXDA result = new DOMXDA(XMLUtils.newDocument(),false);
		result.appendPath("/", "modules", null);
		//ModuleManager mm = (ModuleManager)getContainer().getComponent(ModuleManager.URI);
		BuildAccessor.addConfig(result, operandURI.toString(),null,null,null);
		result.appendPath("/modules/module","/source", XMLUtils.escape(operandURI.toString()));
		IURMeta meta = aHelper.getDependencyMeta("text/xml", 16);
		return new MonoRepresentationImpl(meta, new DOMXDAAspect(result));

	}
}