/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: BuildAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.6 $
 * Last Modified: $Date: 2004/08/05 10:39:42 $
 *****************************************************************************/
package org.ten60.netkernel.ext_install.downloadServer;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.*;

import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier;
import org.ten60.netkernel.layer1.util.Utils;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.IAspectReadableBinaryStream;
import com.ten60.netkernel.module.ModuleManager;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.Version;
import com.ten60.netkernel.module.ModuleDefinition;

import java.net.*;
import java.util.*;
import java.io.*;
import org.w3c.dom.*;
/**
 *	Build a download server configuration from a set of module xars
 * @author  tab
 */
public class BuildAccessor extends XAccessor
{
	public BuildAccessor()
	{	declareArgument(XAccessor.OPERATOR, true, false); // control
	}
	

	protected IURRepresentation source(XAHelper aHelper) throws Exception
	{	
		IXDAReadOnly operator = aHelper.getOperator().getXDA();
		String sourceDirURI = operator.getText("/build/source",true);
		File sourceDir = new File(URI.create(sourceDirURI));
		if (!sourceDir.exists())
		{	throw new NetKernelException("Source Directory Not Found",sourceDirURI,null);
		}
		
		String destDirURI = operator.getText("/build/dest",true);
		File destDir = new File(URI.create(destDirURI));
		if (!destDir.exists())
		{	throw new NetKernelException("Destination Directory Not Found",destDirURI,null);
		}
		
		DOMXDA result = new DOMXDA(XMLUtils.newDocument(),false);
		result.appendPath("/", "modules", null);
		
		FilenameFilter fnf = new FilenameFilter()
		{	public boolean accept(File aFile, String aName)
			{	return (aName.endsWith(".jar") || aName.endsWith(".xar"));
			}
		};
		File[] files = sourceDir.listFiles(fnf);
		ModuleManager mm = (ModuleManager)getContainer().getComponent(ModuleManager.URI);
		for (int i=0; i<files.length; i++)
		{	File f = files[i];
			String uriString = f.toURI().toString();
			String filename = uriString.substring(uriString.lastIndexOf('/')+1,uriString.lastIndexOf('.'));
			// make subdirectory
			File moduleDestDir = new File(destDir, filename+File.separator);
			moduleDestDir.mkdir();
			//copy module jar
			IURRepresentation jar = aHelper.getResource(URI.create(f.toURI().toString()), IURAspect.class);
			URI jarDest = URI.create(moduleDestDir.toURI().toString()+filename+".jar");
			aHelper.setResource(jarDest, jar);
			
			// process config data
			addConfig(result,uriString,filename,mm,moduleDestDir);
		}
		
		URI modules = URI.create(destDirURI+"/modules.xml");
		IURRepresentation modulesRep = DOMXDAAspect.create(new AlwaysExpiredMeta("text/xml", 0), result);
		aHelper.setResource(modules, modulesRep);
		
		return modulesRep;
	}
	
	public static void addConfig(IXDA aResult, String aModuleURIString, String aFilename, ModuleManager aMM, File aModuleDestDir) throws Exception
	{
			URL moduleConfig = new URL("jar:"+aModuleURIString+"!/"+ModuleDefinition.MODULE_CONFIG);
			Reader r = new InputStreamReader(moduleConfig.openStream());
			Document d = XMLUtils.getInstance().parse(r);
			DOMXDA xda = new DOMXDA(d,false);
			aResult.appendPath("/modules", "module", null);
			if (aFilename!=null)
			{	aResult.appendPath("/modules/module[last()]","/source", XMLUtils.escape(aFilename+"/"+aFilename+".jar"));
			}
			String uri = xda.getText("/module/identity/uri",true);
			aResult.appendPath("/modules/module[last()]", "uri", uri);
			String version = new Version(xda.getText("/module/identity/version",true)).toString(3);
			aResult.appendPath("/modules/module[last()]", "version", version);
			String name = xda.getText("/module/info/name",true);
			aResult.appendPath("/modules/module[last()]", "name", name);
			String desc = xda.getText("/module/info/description",true);
			aResult.appendPath("/modules/module[last()]", "desc", desc);
			String type="library";
			try
			{	type = xda.getText("/module/info/type",true);
			} catch (XPathLocationException e) { /*use default*/ }
			aResult.appendPath("/modules/module[last()]", "type", type);
			//dependencies
			aResult.appendPath("/modules/module[last()]", "dependencies", null);
			for (IXDAReadOnlyIterator j = xda.readOnlyIterator("/module/mapping/import"); j.hasNext(); )
			{	j.next();
				String dependencyURI = j.getText("uri",true);
				aResult.appendPath("/modules/module[last()]/dependencies", "module/uri", dependencyURI);
				try
				{	String v = j.getText("version-min",true);
					aResult.appendPath("/modules/module[last()]/dependencies/module[last()]", "version-min", v);
				} catch (XPathLocationException e) { /*use default*/ }
				try
				{	String v = j.getText("version-max",true);
					aResult.appendPath("/modules/module[last()]/dependencies/module[last()]", "version-max", v);
				} catch (XPathLocationException e) { /*use default*/ }
			}
			// icon
			if (aModuleDestDir!=null)
			{
				try
				{	URL moduleEntrypoints = new URL("jar:"+aModuleURIString+"!/entrypoints.xml");
					r = new InputStreamReader(moduleEntrypoints.openStream());
					d = XMLUtils.getInstance().parse(r);
					DOMXDA entrypoints = new DOMXDA(d,false);
					String iconpath = entrypoints.getText("/entrypoints/entrypoint[name='icon']/uri",true);
					ModuleDefinition md = new ModuleDefinition(aModuleURIString, 0, d, aMM);
					iconpath = md.rewrite(new URIdentifier(iconpath)).getSchemeSpecificPart();
					int k = iconpath.lastIndexOf('/');
					if (k<0)
					{	k=0;
					}
					else
					{	k=k+1;
					}
					String iconName = iconpath.substring(k);
					URL iconURL = new URL("jar:"+aModuleURIString+"!"+iconpath);
					InputStream is = iconURL.openStream();
					FileOutputStream fos = new FileOutputStream(aModuleDestDir.toString()+"/"+iconName);
					Utils.pipe(is, fos);
					aResult.appendPath("/modules/module[last()]", "icon", XMLUtils.escape(aFilename+"/"+iconName));
				} catch (Exception e) { /*no icon*/ }
			}
		
	}
	
	
}