/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.tool.logicaleffort.LENodable;
import com.sun.electric.tool.logicaleffort.LEPin;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LENetwork {
    private String name;
    private List<LEPin> pins;
    private List<LENetwork> networks;

    protected LENetwork(String name) {
        this.name = name;
        this.pins = new ArrayList<LEPin>();
        this.networks = new ArrayList<LENetwork>();
    }

    protected void add(LEPin pin) {
        this.pins.add(pin);
    }

    protected void add(LENetwork net) {
        this.networks.add(net);
    }

    protected String getName() {
        return this.name;
    }

    protected Iterator<LENetwork> getSubNets() {
        return this.networks.iterator();
    }

    protected List<LEPin> getAllPins() {
        ArrayList<LEPin> allpins = new ArrayList<LEPin>(this.pins);
        for (LENetwork net : this.networks) {
            allpins.addAll(net.getAllPins());
        }
        return allpins;
    }

    protected void print() {
        this.print("", System.out);
    }

    protected void print(String header, PrintStream out) {
        out.println(header + "Network " + this.name + ", connects to: ");
        for (LEPin pin : this.pins) {
            LENodable leno = pin.getInstance();
            out.println(header + "  " + leno.printOneLine(""));
        }
        for (LENetwork net : this.networks) {
            net.print(header + "  ", out);
        }
    }
}

