/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.metrics;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.tool.routing.metrics.DetouringAmountMetric;
import com.sun.electric.tool.routing.metrics.EvennessMetric;
import com.sun.electric.tool.routing.metrics.RoutingMetric;
import com.sun.electric.tool.routing.metrics.StackedViasAmountMetric;
import com.sun.electric.tool.routing.metrics.UnroutedNetsMetric;
import com.sun.electric.tool.routing.metrics.ViaAmountMetric;
import com.sun.electric.tool.routing.metrics.WireLengthMetric;
import com.sun.electric.util.ElapseTimer;
import com.sun.electric.util.TextUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireQualityMetric
extends RoutingMetric<QualityResults> {
    private static Logger logger = LoggerFactory.getLogger(WireQualityMetric.class);
    ElapseTimer timer;
    String name = WireQualityMetric.class.getName();
    boolean regression = false;

    public WireQualityMetric() {
    }

    public WireQualityMetric(String s, ElapseTimer t) {
        this.name = s;
        this.timer = t;
        this.regression = true;
    }

    @Override
    public QualityResults calculate(Cell cell) {
        QualityResults result2 = new QualityResults();
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String hostname = addr.getHostName();
            Date now = new Date();
            logger.debug("============================");
            if (this.regression) {
                logger.debug("metric name: " + this.name);
                logger.debug("machine: " + hostname);
                logger.debug("date: " + TextUtils.formatDate(now));
                logger.debug("Electric's version: " + Version.getVersion());
            }
            if (this.timer != null) {
                logger.debug("execution time: " + this.timer);
            }
            logger.trace("calculate wire length");
            result2.wireLength = new WireLengthMetric().calculate(cell);
            logger.debug("wire length metric: " + result2.wireLength);
            logger.trace("calculate unrouted nets");
            result2.unroutedSegments = new UnroutedNetsMetric().calculate(cell);
            logger.debug("unrouted nets metric: " + result2.unroutedSegments);
            logger.trace("calculate via amount metric...");
            result2.vias = new ViaAmountMetric().calculate(cell);
            logger.debug("via amount metric: " + result2.vias);
            logger.trace("calculate stacked via amount metric...");
            result2.stackedVias = new StackedViasAmountMetric().calculate(cell);
            logger.debug("stacked via amount metric: " + result2.stackedVias);
            logger.trace("calculate detouring amount metric...");
            result2.detourings = new DetouringAmountMetric().calculate(cell);
            logger.debug("detouring amount metric: " + result2.detourings);
            logger.trace("calculate evenness metric...");
            result2.evenness = new EvennessMetric().calculate(cell);
            logger.debug("evenness metric: " + result2.evenness);
            logger.debug("============================");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return result2;
    }

    @Override
    protected QualityResults reduce(QualityResults result2, ArcInst instance, Network net) {
        throw new UnsupportedOperationException();
    }

    public static class QualityResults {
        public Integer vias;
        public Integer stackedVias;
        public Integer detourings;
        public Double evenness;
        public Double wireLength;
        public Integer unroutedSegments;
    }
}

