/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellRevision;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.ImmutablePortInst;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.Variable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UsageCollector {
    static final BitSet EMPTY_BITSET = new BitSet();
    static final TreeMap<Variable.AttrKey, AbstractTextDescriptor.Unit> EMPTY_ATTRIBUTES = new TreeMap();
    private final ImmutableCell d;
    private final HashMap<CellId, CellUsageInfoBuilder> cellIndices = new HashMap(16, 0.5f);
    private final HashSet<TechId> techUsed = new HashSet(16, 0.5f);

    UsageCollector(ImmutableCell d, ImmutableArrayList<ImmutableNodeInst> nodes, ImmutableArrayList<ImmutableArcInst> arcs, ImmutableArrayList<ImmutableExport> exports) {
        this.d = d;
        for (int nodeIndex = 0; nodeIndex < nodes.size(); ++nodeIndex) {
            ImmutableNodeInst n = (ImmutableNodeInst)nodes.get(nodeIndex);
            if (n.protoId instanceof CellId) {
                CellUsageInfoBuilder cellCount = this.add((CellId)n.protoId, true);
                if (cellCount.isIcon) {
                    for (Variable param : n.getDefinedParams()) {
                        cellCount.addAttribute((Variable.AttrKey)param.getKey(), param.getUnit());
                    }
                    for (int varIndex = 0; varIndex < n.getNumVariables(); ++varIndex) {
                        Variable.Key varKey = n.getVar(varIndex).getKey();
                        if (!varKey.isAttribute()) continue;
                        cellCount.addAttribute((Variable.AttrKey)varKey, null);
                    }
                }
            } else {
                this.techUsed.add(((PrimitiveNodeId)n.protoId).techId);
            }
            for (int chronIndex = 0; chronIndex < n.ports.length; ++chronIndex) {
                ImmutablePortInst pi = n.ports[chronIndex];
                if (pi == ImmutablePortInst.EMPTY) continue;
                PortProtoId pp = n.protoId.getPortId(chronIndex);
                this.add(pp);
            }
        }
        for (int arcIndex = 0; arcIndex < arcs.size(); ++arcIndex) {
            ImmutableArcInst a = (ImmutableArcInst)arcs.get(arcIndex);
            this.techUsed.add(a.protoId.techId);
            this.add(a.tailPortId);
            this.add(a.headPortId);
        }
        for (int portIndex = 0; portIndex < exports.size(); ++portIndex) {
            ImmutableExport e = (ImmutableExport)exports.get(portIndex);
            this.add(e.originalPortId);
        }
    }

    private void add(PortProtoId portId) {
        if (portId instanceof PrimitivePortId) {
            return;
        }
        ExportId eId = (ExportId)portId;
        this.add(eId.getParentId(), false).usedExports.set(eId.chronIndex);
    }

    private CellUsageInfoBuilder add(CellId cellId, boolean isInstance) {
        CellUsageInfoBuilder cellCount = this.cellIndices.get(cellId);
        if (cellCount == null) {
            cellCount = new CellUsageInfoBuilder(this.d.cellId.getUsageIn(cellId));
            this.cellIndices.put(cellId, cellCount);
        }
        if (isInstance) {
            cellCount.instCount++;
        }
        return cellCount;
    }

    BitSet getTechUsages(BitSet oldTechUsages) {
        BitSet techUsages = new BitSet();
        techUsages.set(this.d.techId.techIndex);
        for (TechId techId : this.techUsed) {
            techUsages.set(techId.techIndex);
        }
        return UsageCollector.bitSetWith(oldTechUsages, techUsages);
    }

    CellRevision.CellUsageInfo[] getCellUsages(CellRevision.CellUsageInfo[] oldCellUsages) {
        if (this.cellIndices.isEmpty()) {
            return CellRevision.NULL_CELL_USAGE_INFO_ARRAY;
        }
        CellId parentId = this.d.cellId;
        int length = 0;
        for (CellId cellId : this.cellIndices.keySet()) {
            length = Math.max(length, parentId.getUsageIn((CellId)cellId).indexInParent + 1);
        }
        Object[] newCellUsages = new CellRevision.CellUsageInfo[length];
        for (CellId cellId : this.cellIndices.keySet()) {
            CellUsage u = parentId.getUsageIn(cellId);
            int indexInParent = u.indexInParent;
            CellUsageInfoBuilder cellCount = this.cellIndices.get(cellId);
            if (cellCount == null) continue;
            CellRevision.CellUsageInfo oldC = indexInParent < oldCellUsages.length ? oldCellUsages[indexInParent] : null;
            newCellUsages[indexInParent] = cellCount.getCellUsageInfo(oldC);
        }
        return Arrays.equals(newCellUsages, oldCellUsages) ? oldCellUsages : newCellUsages;
    }

    static BitSet bitSetWith(BitSet oldBitSet, BitSet newBitSet) {
        if (newBitSet.isEmpty()) {
            return EMPTY_BITSET;
        }
        return newBitSet.equals(oldBitSet) ? oldBitSet : newBitSet;
    }

    static TreeMap<Variable.AttrKey, AbstractTextDescriptor.Unit> usedAttributesWith(TreeMap<Variable.AttrKey, AbstractTextDescriptor.Unit> oldAttributes, TreeMap<Variable.AttrKey, AbstractTextDescriptor.Unit> newAttributes) {
        if (newAttributes == null) {
            return null;
        }
        if (newAttributes.isEmpty()) {
            return EMPTY_ATTRIBUTES;
        }
        return newAttributes.equals(oldAttributes) ? oldAttributes : newAttributes;
    }

    private static class CellUsageInfoBuilder {
        private final CellUsage cellUsage;
        private final boolean isIcon;
        private int instCount;
        private final BitSet usedExports = new BitSet();
        private final TreeMap<Variable.AttrKey, AbstractTextDescriptor.Unit> usedAttributes;

        private CellUsageInfoBuilder(CellUsage cellUsage) {
            this.cellUsage = cellUsage;
            this.isIcon = cellUsage.protoId.isIcon();
            this.usedAttributes = this.isIcon ? new TreeMap() : null;
        }

        private void addAttribute(Variable.AttrKey attrKey, AbstractTextDescriptor.Unit unit) {
            AbstractTextDescriptor.Unit oldUnit = this.usedAttributes.get(attrKey);
            if (oldUnit != null) {
                if (unit != oldUnit) {
                    throw new IllegalArgumentException(attrKey + " " + unit);
                }
            } else {
                this.usedAttributes.put(attrKey, unit);
            }
        }

        private CellRevision.CellUsageInfo getCellUsageInfo(CellRevision.CellUsageInfo oldCellUsageInfo) {
            if (oldCellUsageInfo != null) {
                return oldCellUsageInfo.with(this.instCount, this.usedExports, this.usedAttributes);
            }
            return new CellRevision.CellUsageInfo(this.instCount, this.usedExports, this.usedAttributes);
        }
    }
}

